/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import oracle.javatools.util.ArrayIterator;

public class CopyOnWriteList {
    private final Class itemType;
    private Object[] items;

    public CopyOnWriteList() {
        this(Object.class);
    }

    public CopyOnWriteList(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.itemType = clazz;
        this.items = this.newArray(0);
    }

    public synchronized boolean add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("item == null");
        }
        return this.addImpl(this.items.length, object);
    }

    public synchronized boolean add(int n, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("item == null");
        }
        return this.addImpl(n, object);
    }

    public synchronized boolean addIfAbsent(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("item == null");
        }
        int n = this.items.length;
        while (n-- > 0) {
            if (!this.equals(object, this.items[n])) continue;
            return false;
        }
        return this.addImpl(this.items.length, object);
    }

    private boolean addImpl(int n, Object object) {
        int n2 = this.items.length;
        Object[] objectArray = this.newArray(n2 + 1);
        if (n >= n2) {
            System.arraycopy(this.items, 0, objectArray, 0, n2);
            objectArray[n2] = object;
        } else if (n <= 0) {
            objectArray[0] = object;
            System.arraycopy(this.items, 0, objectArray, 1, n2);
        } else {
            System.arraycopy(this.items, 0, objectArray, 0, n);
            objectArray[n] = object;
            System.arraycopy(this.items, n, objectArray, n + 1, n2 - n);
        }
        this.items = objectArray;
        return true;
    }

    public synchronized void clear() {
        this.items = this.newArray(0);
    }

    public synchronized boolean remove(Object object) {
        if (object != null) {
            int n = this.items.length;
            while (n-- > 0) {
                if (!this.equals(object, this.items[n])) continue;
                if (this.items.length == 1) {
                    this.items = this.newArray(0);
                } else {
                    Object[] objectArray = this.newArray(this.items.length - 1);
                    System.arraycopy(this.items, 0, objectArray, 0, n);
                    if (n < objectArray.length) {
                        System.arraycopy(this.items, n + 1, objectArray, n, objectArray.length - n);
                    }
                    this.items = objectArray;
                }
                return true;
            }
        }
        return false;
    }

    public synchronized Object remove(int n) {
        Object object = this.items[n];
        if (this.items.length == 1) {
            this.items = this.newArray(0);
        } else {
            Object[] objectArray = this.newArray(this.items.length - 1);
            System.arraycopy(this.items, 0, objectArray, 0, n);
            if (n < objectArray.length) {
                System.arraycopy(this.items, n + 1, objectArray, n, objectArray.length - n);
            }
            this.items = objectArray;
        }
        return object;
    }

    public synchronized int size() {
        return this.items.length;
    }

    public boolean contains(Object object) {
        Object[] objectArray = this.items;
        int n = 0;
        while (n < objectArray.length) {
            if (this.equals(object, objectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean isEmpty() {
        return this.items.length == 0;
    }

    public Iterator iterator() {
        return new ArrayIterator(this.items);
    }

    public synchronized Object[] getItems() {
        return this.items;
    }

    public String toString() {
        Object[] objectArray = this.items;
        StringBuffer stringBuffer = new StringBuffer("CopyOnWriteList {");
        if (objectArray.length > 0) {
            stringBuffer.append(objectArray[0]);
            int n = 1;
            while (n < objectArray.length) {
                stringBuffer.append(' ');
                stringBuffer.append(objectArray[n]);
                ++n;
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private Object[] newArray(int n) {
        return (Object[])Array.newInstance(this.itemType, n);
    }

    protected boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }
}

