/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class EnvironmentVariables {
    private static Map _vars = EnvironmentVariables.retrieveEnvironmentVars();

    private EnvironmentVariables() {
    }

    public static final synchronized String getVariable(String string) {
        return (String)_vars.get(string.toUpperCase());
    }

    public static final synchronized Map get() {
        return Collections.unmodifiableMap(_vars);
    }

    private static final Map retrieveEnvironmentVars() {
        try {
            Map map = EnvironmentVariables.retrieveEnvironmentVarsImpl();
            return map;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Map map = null;
            return map;
        }
    }

    private static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("windows") >= 0;
    }

    private static final void writeTextFile(File file, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string);
        bufferedWriter.close();
    }

    private static final Map retrieveEnvironmentVarsImpl() throws IOException, InterruptedException {
        String[] stringArray = null;
        File file = null;
        if (EnvironmentVariables.isWindows()) {
            stringArray = new String[]{"cmd.exe", "/c", "set"};
        } else {
            file = File.createTempFile(".jdevenv_set", "sh");
            EnvironmentVariables.writeTextFile(file, "set");
            stringArray = new String[]{"sh", file.getPath()};
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(stringArray).getInputStream()));
        HashMap hashMap = new HashMap();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            EnvironmentVariables.populateVariableMap(hashMap, string);
        }
        if (file != null) {
            file.delete();
        }
        return hashMap;
    }

    private static final void populateVariableMap(Map map, String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(61);
        if (n <= 0 || n >= string.length() - 1) {
            return;
        }
        string2 = string.substring(0, n);
        string3 = string.substring(n + 1).trim();
        if (string2.indexOf(32) >= 0 || string3.equals("")) {
            return;
        }
        map.put(string2.toUpperCase(), string3);
    }
}

