/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIterator
implements Iterator {
    private BufferedReader reader;
    private String previousLine;
    private String nextLine;
    private boolean done;
    private int lineCount;

    public LineIterator(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
    }

    public LineIterator(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public LineIterator(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public boolean hasNext() {
        try {
            this.advance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.done ^ true;
    }

    public Object next() {
        try {
            this.advance();
        }
        catch (IOException iOException) {
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            noSuchElementException.initCause(iOException);
            throw noSuchElementException;
        }
        if (this.nextLine == null) {
            throw new NoSuchElementException();
        }
        this.previousLine = this.nextLine;
        this.nextLine = null;
        ++this.lineCount;
        return this.previousLine;
    }

    public void repeat() {
        if (this.previousLine == null) {
            throw new NoSuchElementException();
        }
        this.nextLine = this.previousLine;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advance() throws IOException {
        if (this.nextLine == null) {
            this.nextLine = this.reader.readLine();
            if (this.nextLine == null) {
                this.done = true;
                this.previousLine = null;
            }
        }
    }
}

