/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.util.SynchronizedQueue;

public final class Log {
    private final boolean enabled;
    private final String name;
    private static final boolean any;
    private static boolean teeErrors;
    private static Set names;
    private static final long ORIGIN;
    private static Map formatters;
    private static Logger logger;
    private static Formatter DEFAULT_FORMATTER;
    private static char[] tagBuffer;
    private static char[] timeBuffer;

    public static void error(String string) {
        Log.error(string, null);
    }

    public static void error(String string, Object object) {
        Log.error(string, new Object[]{object});
    }

    public static void error(String string, Object object, Object object2) {
        Log.error(string, new Object[]{object, object2});
    }

    public static void error(String string, Object object, Object object2, Object object3) {
        Log.error(string, new Object[]{object, object2, object3});
    }

    public static void error(String string, Object object, Object object2, Object object3, Object object4) {
        Log.error(string, new Object[]{object, object2, object3, object4});
    }

    public static void error(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        Log.error(string, new Object[]{object, object2, object3, object4, object5});
    }

    public static void error(String string, Object[] objectArray) {
        Log.printerror(string, objectArray);
    }

    public Log(String string) {
        if (any) {
            if (names.contains(string)) {
                this.enabled = true;
                this.name = string;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String string, String string2) {
        if (any) {
            if (names.contains(string)) {
                this.enabled = true;
                this.name = string;
            } else if (names.contains(string2)) {
                this.enabled = true;
                this.name = string2;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String string, String string2, String string3) {
        if (any) {
            if (names.contains(string)) {
                this.enabled = true;
                this.name = string;
            } else if (names.contains(string2)) {
                this.enabled = true;
                this.name = string2;
            } else if (names.contains(string3)) {
                this.enabled = true;
                this.name = string3;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String[] stringArray) {
        if (any) {
            String string = null;
            int n = 0;
            while (n < stringArray.length) {
                if (names.contains(stringArray[n])) {
                    string = stringArray[n];
                    break;
                }
                ++n;
            }
            if (string != null) {
                this.enabled = true;
                this.name = string;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean trace(String string) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, null);
        return true;
    }

    public boolean trace(String string, Object object) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{object});
        return true;
    }

    public boolean trace(String string, int n) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n)});
        return true;
    }

    public boolean trace(String string, long l) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Long(l)});
        return true;
    }

    public boolean trace(String string, boolean bl) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{bl});
        return true;
    }

    public boolean trace(String string, Object object, Object object2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{object, object2});
        return true;
    }

    public boolean trace(String string, int n, Object object) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), object});
        return true;
    }

    public boolean trace(String string, int n, int n2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), new Integer(n2)});
        return true;
    }

    public boolean trace(String string, long l, Object object) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Long(l), object});
        return true;
    }

    public boolean trace(String string, boolean bl, Object object) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Boolean(bl), object});
        return true;
    }

    public boolean trace(String string, boolean bl, boolean bl2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Boolean(bl), new Boolean(bl2)});
        return true;
    }

    public boolean trace(String string, Object object, Object object2, Object object3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{object, object2, object3});
        return true;
    }

    public boolean trace(String string, int n, Object object, Object object2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), object, object2});
        return true;
    }

    public boolean trace(String string, int n, int n2, Object object) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), new Integer(n2), object});
        return true;
    }

    public boolean trace(String string, int n, int n2, int n3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), new Integer(n2), new Integer(n3)});
        return true;
    }

    public boolean trace(String string, Object object, Object object2, Object object3, Object object4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{object, object2, object3, object4});
        return true;
    }

    public boolean trace(String string, int n, Object object, Object object2, Object object3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), object, object2, object3});
        return true;
    }

    public boolean trace(String string, int n, int n2, Object object, Object object2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), new Integer(n2), object, object2});
        return true;
    }

    public boolean trace(String string, int n, int n2, int n3, Object object) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), object});
        return true;
    }

    public boolean trace(String string, int n, int n2, int n3, int n4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
        return true;
    }

    public boolean trace(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{object, object2, object3, object4, object5});
        return true;
    }

    public boolean trace(String string, int n, Object object, Object object2, Object object3, Object object4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), object, object2, object3, object4});
        return true;
    }

    public boolean trace(String string, int n, int n2, Object object, Object object2, Object object3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, new Object[]{new Integer(n), new Integer(n2), object, object2, object3});
        return true;
    }

    public boolean trace(String string, Object[] objectArray) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, string, objectArray);
        return true;
    }

    public static void addFormatter(Class clazz, Formatter formatter) {
        formatters.put(clazz, formatter);
    }

    public static String format(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Log.append(stringBuffer, string, objectArray);
        return stringBuffer.toString();
    }

    public static void append(StringBuffer stringBuffer, String string, Object[] objectArray) {
        int n = string.length();
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        cArray[n] = '\u0000';
        int n2 = 0;
        while (true) {
            char c;
            int n3;
            char c2;
            int n4 = n2;
            do {
                if ((c2 = cArray[n2++]) != '\u0000') continue;
                stringBuffer.append(cArray, n4, n2 - n4 - 1);
                return;
            } while (c2 != '{' || (n3 = Character.digit(cArray[n2], 10)) < 0);
            stringBuffer.append(cArray, n4, n2 - n4 - 1);
            Object object = n3 < objectArray.length ? objectArray[n3] : "?";
            Log.append(stringBuffer, object);
            do {
                int n5 = ++n2;
                ++n2;
                c = cArray[n5];
                if (c != '\u0000') continue;
                stringBuffer.append('?');
                return;
            } while (c != '}');
        }
    }

    public static StringBuffer append(StringBuffer stringBuffer, Object object) {
        Formatter formatter = Log.getFormatter(object);
        try {
            formatter.append(stringBuffer, object);
        }
        catch (Throwable throwable) {
            stringBuffer.append('<').append(throwable.getMessage()).append('>');
        }
        return stringBuffer;
    }

    public static Formatter getFormatter(Object object) {
        if (object == null) {
            return DEFAULT_FORMATTER;
        }
        return Log.getFormatter(object.getClass());
    }

    public static Formatter getFormatter(Class clazz) {
        Formatter formatter;
        block3: {
            formatter = (Formatter)formatters.get(clazz);
            if (formatter != null) break block3;
            Class clazz2 = clazz;
            do {
                Class<?>[] classArray = clazz2.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    formatter = (Formatter)formatters.get(classArray[n]);
                    if (formatter != null) {
                        formatters.put(clazz, formatter);
                        break block3;
                    }
                    ++n;
                }
                if ((clazz2 = clazz2.getSuperclass()) != null) continue;
                formatter = DEFAULT_FORMATTER;
                break block3;
            } while ((formatter = (Formatter)formatters.get(clazz2)) == null);
            formatters.put(clazz, formatter);
        }
        return formatter;
    }

    static {
        ORIGIN = System.currentTimeMillis();
        formatters = new HashMap();
        DEFAULT_FORMATTER = new DefaultFormatter(null);
        formatters.put(Object.class, DEFAULT_FORMATTER);
        formatters.put(boolean[].class, new BooleanArrayFormatter(null));
        formatters.put(byte[].class, new ByteArrayFormatter(null));
        formatters.put(char[].class, new CharArrayFormatter(null));
        formatters.put(short[].class, new ShortArrayFormatter(null));
        formatters.put(int[].class, new IntArrayFormatter(null));
        formatters.put(long[].class, new LongArrayFormatter(null));
        formatters.put(float[].class, new FloatArrayFormatter(null));
        formatters.put(double[].class, new DoubleArrayFormatter(null));
        String string = System.getProperty("audit.trace");
        if (string != null) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while ((n = string.indexOf(44, n2)) >= 0) {
                arrayList.add(string.substring(n2, n));
                n2 = n + 1;
            }
            arrayList.add(string.substring(n2));
            if (!arrayList.isEmpty()) {
                boolean bl = false;
                any = true;
                names = new HashSet();
                String string2 = "error";
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    String string3 = (String)arrayList.get(n3);
                    if (string3.length() != 0) {
                        if (string3.charAt(0) == '!') {
                            if ((string3 = string3.substring(1).trim()).equals("synchronous")) {
                                bl = true;
                            } else {
                                string2 = string3;
                                teeErrors = "error".equalsIgnoreCase(string2) ^ true;
                            }
                        } else {
                            names.add(string3);
                        }
                    }
                    ++n3;
                }
                logger = bl ? new SynchronousLogger(string2) : new AsynchronousLogger(string2);
            } else {
                any = false;
            }
        } else {
            any = false;
        }
        tagBuffer = new char[]{' ', ' ', ' ', '0'};
        timeBuffer = new char[]{' ', ' ', ' ', ' ', ' ', '.', '0', '0', '0'};
    }

    private static void printerror(String string, Object[] objectArray) {
        if (logger != null && !logger.isDisabled()) {
            if (teeErrors) {
                Log.print(System.err, "ERROR", System.currentTimeMillis(), Thread.currentThread().getName(), string, objectArray);
            }
            logger.add("ERROR", string, objectArray);
        } else {
            Log.print(System.err, "ERROR", System.currentTimeMillis(), Thread.currentThread().getName(), string, objectArray);
        }
    }

    private static void trace(String string, String string2, Object[] objectArray) {
        logger.add(string, string2, objectArray);
    }

    private static PrintStream getStream(String string) {
        PrintStream printStream;
        if (string.equalsIgnoreCase("error")) {
            printStream = System.err;
            System.err.println("Audit: tracing enabled to standard error");
        } else if (string.equalsIgnoreCase("output")) {
            printStream = System.out;
            System.err.println("Audit: tracing enabled to standard output");
        } else {
            try {
                printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(string)));
                System.err.println("Audit: tracing enabled to " + new File(string).getAbsolutePath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                printStream = null;
                System.err.println("Audit: tracing aborted: file " + new File(string).getAbsolutePath() + " not created:");
                fileNotFoundException.printStackTrace(System.err);
            }
        }
        return printStream;
    }

    private static void appendTag(StringBuffer stringBuffer) {
        Log.tag(3);
        stringBuffer.append(tagBuffer);
    }

    private static void tag(int n) {
        if (n < 0) {
            return;
        }
        int n2 = n;
        tagBuffer[n2] = (char)(tagBuffer[n2] + '\u0001');
        char c = tagBuffer[n2];
        if (c < '0') {
            Log.tagBuffer[n] = 49;
        } else if (c > '9') {
            Log.tagBuffer[n] = 48;
            Log.tag(n - 1);
        }
    }

    private static void appendTime(StringBuffer stringBuffer, long l) {
        long l2 = l - ORIGIN;
        int n = timeBuffer.length;
        while (l2 > 0L && n > 0) {
            Log.timeBuffer[--n] = (char)((long)48 + l2 % (long)10);
            l2 /= (long)10;
        }
        stringBuffer.append(timeBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(PrintStream printStream, String string, long l, String string2, String string3, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("____AUDIT ");
        stringBuffer.append(string);
        stringBuffer.append(' ');
        Log.appendTag(stringBuffer);
        stringBuffer.append(':');
        Log.appendTime(stringBuffer, l);
        stringBuffer.append(" [");
        stringBuffer.append(string2);
        stringBuffer.append("] ");
        if (objectArray == null) {
            stringBuffer.append(string3);
            printStream.println(stringBuffer);
        } else {
            Log.append(stringBuffer, string3, objectArray);
            if (objectArray.length > 0 && objectArray[objectArray.length - 1] instanceof Throwable) {
                PrintStream printStream2 = printStream;
                synchronized (printStream2) {
                    printStream.println(stringBuffer);
                    Throwable throwable = (Throwable)objectArray[objectArray.length - 1];
                    Log.printStackTrace(throwable, printStream);
                }
            } else {
                printStream.println(stringBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStackTrace(Throwable throwable, PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = 0;
            while (n < stackTraceElementArray.length) {
                printStream.println("\tat " + stackTraceElementArray[n]);
                ++n;
            }
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                Log.printStackTraceAsCause(throwable2, printStream, stackTraceElementArray);
            }
        }
    }

    private static void printStackTraceAsCause(Throwable throwable, PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable2;
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        int n2 = stackTraceElementArray.length - 1;
        while (n >= 0 && n2 >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[n2])) {
            --n;
            --n2;
        }
        int n3 = stackTraceElementArray2.length - 1 - n;
        printStream.println("Caused by: " + throwable);
        int n4 = 0;
        while (n4 <= n) {
            printStream.println("\tat " + stackTraceElementArray2[n4]);
            ++n4;
        }
        if (n3 != 0) {
            printStream.println("\t... " + n3 + " more");
        }
        if ((throwable2 = throwable.getCause()) != null) {
            Log.printStackTraceAsCause(throwable2, printStream, stackTraceElementArray2);
        }
    }

    static void maS$print(PrintStream printStream, String string, long l, String string2, String string3, Object[] objectArray) {
        Log.print(printStream, string, l, string2, string3, objectArray);
    }

    static PrintStream maS$getStream(String string) {
        return Log.getStream(string);
    }

    public interface Formatter {
        public void append(StringBuffer var1, Object var2);
    }

    private static class Trace {
        private String name;
        private long time;
        private String thread;
        private String message;
        private Object[] parameters;

        public Trace(String string, long l, String string2, String string3, Object[] objectArray) {
            this.name = string;
            this.time = l;
            this.thread = string2;
            this.message = string3;
            this.parameters = objectArray;
        }

        static String ra$name(Trace trace) {
            return trace.name;
        }

        static long ra$time(Trace trace) {
            return trace.time;
        }

        static String ra$thread(Trace trace) {
            return trace.thread;
        }

        static String ra$message(Trace trace) {
            return trace.message;
        }

        static Object[] ra$parameters(Trace trace) {
            return trace.parameters;
        }
    }

    private interface Logger {
        public void add(String var1, String var2, Object[] var3);

        public boolean isDisabled();
    }

    private static class SynchronousLogger
    implements Logger {
        private final boolean disabled;
        private final PrintStream stream;

        public SynchronousLogger(String string) {
            this.stream = Log.maS$getStream(string);
            boolean bl = this.disabled = this.stream == null;
            if (this.stream != null) {
                try {
                    Runtime.getRuntime().addShutdownHook(new 1());
                }
                catch (IllegalStateException illegalStateException) {
                    this.stream.flush();
                }
            }
        }

        public void add(String string, String string2, Object[] objectArray) {
            if (this.disabled) {
                return;
            }
            Log.maS$print(this.stream, string, System.currentTimeMillis(), Thread.currentThread().getName(), string2, objectArray);
        }

        public boolean isDisabled() {
            return this.stream != null;
        }

        static PrintStream ra$stream(SynchronousLogger synchronousLogger) {
            return synchronousLogger.stream;
        }

        public final class 1
        extends Thread {
            public void run() {
                SynchronousLogger.ra$stream(SynchronousLogger.this).flush();
            }
        }
    }

    private static class AsynchronousLogger
    implements Runnable,
    Logger {
        private String destination;
        private SynchronizedQueue queue;
        private Thread thread;
        private volatile boolean stopped;
        private volatile boolean disabled;

        public AsynchronousLogger(String string) {
            this.destination = string;
            this.queue = new SynchronizedQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String string, String string2, Object[] objectArray) {
            if (this.disabled) {
                return;
            }
            Trace trace = new Trace(string, System.currentTimeMillis(), Thread.currentThread().getName(), string2, objectArray);
            SynchronizedQueue synchronizedQueue = this.queue;
            synchronized (synchronizedQueue) {
                if (this.thread == null) {
                    this.thread = new Thread((Runnable)this, "AuditLogger");
                    this.thread.setPriority(1);
                    this.thread.start();
                }
                this.queue.add(trace);
            }
        }

        public void run() {
            PrintStream printStream = Log.maS$getStream(this.destination);
            this.destination = null;
            if (printStream == null) {
                this.disabled = true;
                this.queue.setEnabled(false);
                this.queue.clear();
                return;
            }
            try {
                Runtime.getRuntime().addShutdownHook(new 1(this, printStream));
            }
            catch (IllegalStateException illegalStateException) {
                this.stopped = true;
            }
            while (!this.stopped) {
                try {
                    Trace trace = (Trace)this.queue.remove();
                    Log.maS$print(printStream, Trace.ra$name(trace), Trace.ra$time(trace), Trace.ra$thread(trace), Trace.ra$message(trace), Trace.ra$parameters(trace));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            while (!this.queue.isEmpty()) {
                try {
                    Trace trace = (Trace)this.queue.remove(0L);
                    Log.maS$print(printStream, Trace.ra$name(trace), Trace.ra$time(trace), Trace.ra$thread(trace), Trace.ra$message(trace), Trace.ra$parameters(trace));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            printStream.close();
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        static void wa$stopped(AsynchronousLogger asynchronousLogger, boolean bl) {
            asynchronousLogger.stopped = bl;
        }

        static Thread ra$thread(AsynchronousLogger asynchronousLogger) {
            return asynchronousLogger.thread;
        }

        public final class 1
        extends Thread {
            private final /* synthetic */ PrintStream v$stream;
            final /* synthetic */ AsynchronousLogger this$0;

            public void run() {
                this.v$stream.flush();
                AsynchronousLogger.wa$stopped(this.this$0, true);
                AsynchronousLogger.ra$thread(this.this$0).interrupt();
            }

            public 1(AsynchronousLogger asynchronousLogger, PrintStream printStream) {
                this.v$stream = printStream;
                this.this$0 = asynchronousLogger;
            }
        }
    }

    private static class DefaultFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            if (object == null) {
                stringBuffer.append("null");
            } else {
                Class<?> clazz = object.getClass();
                if (!clazz.isArray()) {
                    stringBuffer.append(object);
                } else {
                    Class<?> clazz2 = clazz.getComponentType();
                    stringBuffer.append(clazz2.getName());
                    stringBuffer.append("[]{");
                    Object[] objectArray = (Object[])object;
                    if (objectArray.length > 0) {
                        this.append(stringBuffer, objectArray[0]);
                        int n = 1;
                        while (n < objectArray.length) {
                            stringBuffer.append(", ");
                            Log.append(stringBuffer, objectArray[n]);
                            ++n;
                        }
                    }
                    stringBuffer.append("}");
                }
            }
        }

        private DefaultFormatter() {
        }

        DefaultFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BooleanArrayFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            stringBuffer.append('{');
            boolean[] blArray = (boolean[])object;
            if (blArray.length > 0) {
                stringBuffer.append(blArray[0]);
            }
            int n = 1;
            while (n < blArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(blArray[n]);
                ++n;
            }
            stringBuffer.append('}');
        }

        private BooleanArrayFormatter() {
        }

        BooleanArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ByteArrayFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            stringBuffer.append('{');
            byte[] byArray = (byte[])object;
            if (byArray.length > 0) {
                stringBuffer.append(byArray[0]);
            }
            int n = 1;
            while (n < byArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(byArray[n]);
                ++n;
            }
            stringBuffer.append('}');
        }

        private ByteArrayFormatter() {
        }

        ByteArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class CharArrayFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            stringBuffer.append('\"');
            char[] cArray = (char[])object;
            int n = 0;
            while (n < cArray.length) {
                char c = cArray[n];
                switch (c) {
                    case '\b': {
                        stringBuffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        break;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        break;
                    }
                    case '\f': {
                        stringBuffer.append("\\f");
                        break;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("\\\"");
                        break;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        if (c >= ' ' || c < '\u007f') {
                            stringBuffer.append(c);
                            break;
                        }
                        stringBuffer.append("\\u");
                        String string = Integer.toHexString(c);
                        int n2 = string.length();
                        while (n2 < 4) {
                            stringBuffer.append('0');
                            ++n2;
                        }
                        stringBuffer.append(string);
                    }
                }
                ++n;
            }
            stringBuffer.append('\"');
        }

        private CharArrayFormatter() {
        }

        CharArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ShortArrayFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            stringBuffer.append('{');
            short[] sArray = (short[])object;
            if (sArray.length > 0) {
                stringBuffer.append(sArray[0]);
            }
            int n = 1;
            while (n < sArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(sArray[n]);
                ++n;
            }
            stringBuffer.append('}');
        }

        private ShortArrayFormatter() {
        }

        ShortArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class IntArrayFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            stringBuffer.append('{');
            int[] nArray = (int[])object;
            if (nArray.length > 0) {
                stringBuffer.append(nArray[0]);
            }
            int n = 1;
            while (n < nArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(nArray[n]);
                ++n;
            }
            stringBuffer.append('}');
        }

        private IntArrayFormatter() {
        }

        IntArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class LongArrayFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            stringBuffer.append('{');
            long[] lArray = (long[])object;
            if (lArray.length > 0) {
                stringBuffer.append(lArray[0]);
            }
            int n = 1;
            while (n < lArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(lArray[n]);
                ++n;
            }
            stringBuffer.append('}');
        }

        private LongArrayFormatter() {
        }

        LongArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class FloatArrayFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            stringBuffer.append('{');
            float[] fArray = (float[])object;
            if (fArray.length > 0) {
                stringBuffer.append(fArray[0]);
            }
            int n = 1;
            while (n < fArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(fArray[n]);
                ++n;
            }
            stringBuffer.append('}');
        }

        private FloatArrayFormatter() {
        }

        FloatArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DoubleArrayFormatter
    implements Formatter {
        public void append(StringBuffer stringBuffer, Object object) {
            stringBuffer.append('{');
            double[] dArray = (double[])object;
            if (dArray.length > 0) {
                stringBuffer.append(dArray[0]);
            }
            int n = 1;
            while (n < dArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(dArray[n]);
                ++n;
            }
            stringBuffer.append('}');
        }

        private DoubleArrayFormatter() {
        }

        DoubleArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

