/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

public class PlatformUtils {
    private static String _osName;
    private static String _osVersion;
    public static final int OS_UNKNOWN = 0;
    public static final int OS_LINUX = 1;
    public static final int OS_MAC = 2;
    public static final int OS_MAC_PANTHER = 3;
    public static final int OS_MAC_TIGER = 4;
    public static final int OS_WINDOWS = 5;
    public static final int OS_WINDOWS_NT = 6;
    public static final int OS_WINDOWS_2K = 7;
    public static final int OS_WINDOWS_XP = 8;
    private static int _platform;

    static {
        String string;
        _platform = 0;
        _osName = System.getProperty("os.name");
        if (_osName == null) {
            _osName = "";
        }
        if ((_osVersion = System.getProperty("os.version")) == null) {
            _osVersion = "";
        }
        if ((string = _osName.toLowerCase()).startsWith("linux")) {
            _platform = 1;
        } else if (string.startsWith("mac os x")) {
            _platform = _osVersion.startsWith("10.4") ? 4 : (_osVersion.startsWith("10.3") ? 3 : 2);
        } else if (string.startsWith("windows")) {
            _platform = string.startsWith("windows xp") ? 8 : (string.startsWith("windows 2000") ? 7 : (string.startsWith("windows nt") ? 6 : 5));
        }
    }

    private PlatformUtils() {
    }

    public static String osName() {
        return _osName;
    }

    public static String osVersion() {
        return _osVersion;
    }

    public static int getPlatform() {
        return _platform;
    }

    public static boolean isLinux() {
        return _platform == 1;
    }

    public static boolean isMac() {
        return _platform >= 2 && _platform < 5;
    }

    public static boolean isMacPanther() {
        return _platform == 3;
    }

    public static boolean isMacTiger() {
        return _platform == 4;
    }

    public static boolean isWindows() {
        return _platform >= 5;
    }

    public static boolean isWindowsNT() {
        return _platform == 6;
    }

    public static boolean isWindows2K() {
        return _platform == 7;
    }

    public static boolean isWindowsXP() {
        return _platform == 8;
    }

    public static boolean isAtLeastMacPanther() {
        return _platform >= 3 && _platform < 5;
    }

    public static boolean isAtLeastMacTiger() {
        return _platform >= 4 && _platform < 5;
    }

    public static boolean isAtLeastWindowsNT() {
        return _platform >= 6;
    }

    public static boolean isAtLeastWindows2K() {
        return _platform >= 7;
    }

    public static boolean isAtLeastWindowsXP() {
        return _platform >= 8;
    }
}

