/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.javatools.resource.NullResources;
import oracle.javatools.util.BundleLoader;
import oracle.javatools.util.EnumerationStack;

public class ResourcePicker
extends ResourceBundle {
    public static final String s_INDIRECTION = "@>";
    private static Method s_handleGetObject;
    private static Field s_parentField;
    private static ResourceBundle[] s_defaultRes;
    private static ResourceBundle[] s_nullRes;
    private static final Map s_pickers;
    protected ResourceBundle[] m_resource;
    protected ResourceBundle[] m_defaultRes;
    protected MessageFormat m_formatter;
    protected Vector m_keyList;
    private Map m_imageCache;

    static {
        s_pickers = new HashMap();
        try {
            s_handleGetObject = ResourceBundle.class.getDeclaredMethod("handleGetObject", String.class);
            s_handleGetObject.setAccessible(true);
            s_parentField = ResourceBundle.class.getDeclaredField("parent");
            s_parentField.setAccessible(true);
            s_defaultRes = ResourcePicker.getResources(BundleLoader.getBundle("oracle.javatools.resource.DefaultResource"));
            s_nullRes = new ResourceBundle[]{new NullResources()};
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ResourcePicker(ResourceBundle resourceBundle, ResourceBundle resourceBundle2) {
        this(resourceBundle, resourceBundle2 == null ? s_nullRes : ResourcePicker.getResources(resourceBundle2));
    }

    public ResourcePicker(ResourceBundle resourceBundle) {
        this(resourceBundle, s_defaultRes);
    }

    private ResourcePicker(ResourceBundle resourceBundle, ResourceBundle[] resourceBundleArray) {
        this.m_resource = ResourcePicker.getResources(resourceBundle);
        this.m_defaultRes = resourceBundleArray;
        this.m_formatter = new MessageFormat("DUMMY");
    }

    public ResourcePicker(String string, String string2) throws MissingResourceException {
        this(BundleLoader.getBundle(string + ".res." + string2), s_defaultRes);
    }

    public ResourcePicker(Class clazz) throws MissingResourceException {
        this(BundleLoader.getBundle(clazz.getPackage().getName() + ".res." + "Resource"), s_defaultRes);
    }

    public ResourcePicker(Class clazz, String string) throws MissingResourceException {
        this(BundleLoader.getBundle(clazz.getPackage().getName() + ".res." + string), s_defaultRes);
    }

    public String getString(String string, Object[] objectArray) {
        String string2 = this.getString(string);
        return this.formatString(string2, objectArray);
    }

    public String getString(String string, Object object) {
        return this.getString(string, new Object[]{object});
    }

    public String formatString(String string, Object[] objectArray) {
        if (string != null) {
            this.m_formatter.applyPattern(string);
            StringBuffer stringBuffer = new StringBuffer();
            return this.m_formatter.format(objectArray, stringBuffer, (FieldPosition)null).toString();
        }
        return "";
    }

    public void start(Container container) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(container.getName());
        stringBuffer.append(".");
        this.dealWithObject(container, stringBuffer, 0);
        this.fillSubComponents(container, stringBuffer);
    }

    public void fillComponent(Component component) {
        StringBuffer stringBuffer;
        String string = component.getName();
        if (string != null) {
            stringBuffer = new StringBuffer(component.getName());
            stringBuffer.append('.');
        } else {
            stringBuffer = new StringBuffer();
        }
        if (!(component instanceof ResourceFree)) {
            this.dealWithObject(component, stringBuffer, 0);
        }
        if (component instanceof Container) {
            this.fillSubComponents((Container)component, stringBuffer);
        }
    }

    protected void fillSubComponents(Container container, StringBuffer stringBuffer) {
        Component[] componentArray;
        if (container instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)container;
            componentArray = new Component[jTabbedPane.getTabCount()];
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n] = jTabbedPane.getComponentAt(n);
                ++n;
            }
        } else if (container instanceof JMenuBar) {
            JMenuBar jMenuBar = (JMenuBar)container;
            componentArray = new Component[jMenuBar.getMenuCount()];
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n] = jMenuBar.getComponent(n);
                ++n;
            }
        } else if (container instanceof JPopupMenu) {
            JPopupMenu jPopupMenu = (JPopupMenu)container;
            componentArray = new Component[jPopupMenu.getComponentCount()];
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n] = jPopupMenu.getComponent(n);
                ++n;
            }
        } else {
            componentArray = container instanceof JMenu ? ((JMenu)container).getMenuComponents() : container.getComponents();
        }
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof ResourceBase) {
                this.fillComponent(componentArray[n2]);
            } else {
                String string = componentArray[n2].getName();
                if (string != null) {
                    stringBuffer.append(string).append('.');
                }
                if (!(componentArray[n2] instanceof ResourceFree)) {
                    this.dealWithObject(componentArray[n2], stringBuffer, n);
                }
                if (componentArray[n2] instanceof Container) {
                    this.fillSubComponents((Container)componentArray[n2], stringBuffer);
                }
                stringBuffer.setLength(n);
            }
            ++n2;
        }
    }

    protected void dealWithObject(Object object, StringBuffer stringBuffer, int n) {
    }

    protected void dealWithObject(Component component, StringBuffer stringBuffer, int n) {
        if (component instanceof JComponent) {
            this.dealWithObject((JComponent)component, stringBuffer, n);
        } else if (component instanceof JDialog) {
            this.dealWithObject((JDialog)component, stringBuffer, n);
        } else if (component instanceof JFrame) {
            this.dealWithObject((JFrame)component, stringBuffer, n);
        }
    }

    protected void dealWithObject(JComponent jComponent, StringBuffer stringBuffer, int n) {
        String string;
        Border border;
        String string2 = this.getStringResource(stringBuffer, "tooltip", n);
        if (string2 != null) {
            jComponent.setToolTipText(string2);
        }
        if ((border = jComponent.getBorder()) instanceof TitledBorder && (string = this.getStringResource(stringBuffer, "bordertitle", n)) != null) {
            ((TitledBorder)border).setTitle(string);
        }
        if (jComponent instanceof AbstractButton) {
            this.dealWithObject((AbstractButton)jComponent, stringBuffer, n);
        } else if (jComponent instanceof JTextComponent) {
            this.dealWithObject((JTextComponent)jComponent, stringBuffer, n);
        } else if (jComponent instanceof JLabel) {
            this.dealWithObject((JLabel)jComponent, stringBuffer, n);
        } else if (jComponent instanceof JTable) {
            this.dealWithObject((JTable)jComponent, stringBuffer, n);
        } else if (jComponent instanceof JInternalFrame) {
            this.dealWithObject((JInternalFrame)jComponent, stringBuffer, n);
        } else if (jComponent instanceof MultiLineLabel) {
            this.dealWithObject((MultiLineLabel)jComponent, stringBuffer, n);
        } else if (jComponent instanceof DialogHeader) {
            this.dealWithObject((DialogHeader)jComponent, stringBuffer, n);
        }
    }

    void dealWithObject(AbstractButton abstractButton, StringBuffer stringBuffer, int n) {
        ImageIcon imageIcon;
        String string;
        KeyStroke keyStroke;
        String string2;
        String string3 = this.getStringResource(stringBuffer, "text", n);
        String string4 = this.getStringResource(stringBuffer, "mnemonic", n);
        if (string4 != null) {
            abstractButton.setMnemonic(string4.charAt(0));
        }
        if ((string2 = this.getStringResource(stringBuffer, "key", n)) != null && (keyStroke = KeyStroke.getKeyStroke(string2)) != null) {
            if (abstractButton instanceof JMenuItem) {
                ((JMenuItem)abstractButton).setAccelerator(keyStroke);
            } else {
                AbstractButton abstractButton2 = abstractButton;
                abstractButton.registerKeyboardAction(new 1(this, abstractButton2), string2, keyStroke, 2);
            }
        }
        if ((string = this.getStringResource(stringBuffer, "image", n)) != null && (imageIcon = this.getImageResource(string)) != null) {
            abstractButton.setIcon(imageIcon);
            if ((string3 == null || string3.length() == 0) && abstractButton instanceof JButton) {
                abstractButton.setMargin(new Insets(0, 0, 0, 0));
                ((JButton)abstractButton).setDefaultCapable(false);
            }
        }
        if (string3 != null) {
            abstractButton.setText(string3);
        } else if (abstractButton.getName() != null && (abstractButton.getText() == null || abstractButton.getText().length() == 0) && abstractButton.getIcon() == null) {
            abstractButton.setText("!NLS " + abstractButton.getName() + ".text");
        }
    }

    void dealWithObject(JTextComponent jTextComponent, StringBuffer stringBuffer, int n) {
        String string = this.getStringResource(stringBuffer, "text", n);
        if (string != null) {
            jTextComponent.setText(string);
        }
    }

    void dealWithObject(JLabel jLabel, StringBuffer stringBuffer, int n) {
        ImageIcon imageIcon;
        String string;
        String string2;
        String string3 = this.getStringResource(stringBuffer, "text", n);
        if (string3 != null) {
            jLabel.setText(string3);
        }
        if ((string2 = this.getStringResource(stringBuffer, "mnemonic", n)) != null) {
            jLabel.setDisplayedMnemonic(string2.charAt(0));
        }
        if ((string = this.getStringResource(stringBuffer, "image", n)) != null && (imageIcon = this.getImageResource(string)) != null) {
            jLabel.setIcon(imageIcon);
        }
    }

    void dealWithObject(JTable jTable, StringBuffer stringBuffer, int n) {
        TableColumnModel tableColumnModel = this.getHeaders(stringBuffer, n);
        if (tableColumnModel != null) {
            jTable.setColumnModel(tableColumnModel);
        }
    }

    void dealWithObject(JMenuBar jMenuBar, StringBuffer stringBuffer, int n) {
        this.fillSubComponents(jMenuBar, stringBuffer);
    }

    void dealWithObject(JPopupMenu jPopupMenu, StringBuffer stringBuffer, int n) {
        this.fillSubComponents(jPopupMenu, stringBuffer);
    }

    void dealWithObject(JFrame jFrame, StringBuffer stringBuffer, int n) {
        String string = this.getStringResource(stringBuffer, "title", n);
        if (string != null) {
            jFrame.setTitle(string);
        }
    }

    void dealWithObject(JInternalFrame jInternalFrame, StringBuffer stringBuffer, int n) {
        String string = this.getStringResource(stringBuffer, "title", n);
        if (string != null) {
            jInternalFrame.setTitle(string);
        }
    }

    void dealWithObject(JDialog jDialog, StringBuffer stringBuffer, int n) {
        JMenuBar jMenuBar;
        String string = this.getStringResource(stringBuffer, "title", n);
        if (string != null) {
            jDialog.setTitle(string);
        }
        if ((jMenuBar = jDialog.getJMenuBar()) != null) {
            int n2 = stringBuffer.length();
            stringBuffer.append("menubar.");
            this.fillSubComponents(jMenuBar, stringBuffer);
        }
    }

    private void dealWithObject(DialogHeader dialogHeader, StringBuffer stringBuffer, int n) {
        String string;
        String string2 = this.getStringResource(stringBuffer, "title", n);
        if (string2 != null) {
            dialogHeader.setHeaderTitle(string2);
        }
        if ((string = this.getStringResource(stringBuffer, "description", n)) != null) {
            dialogHeader.setHeaderDescription(string);
        }
    }

    void dealWithObject(MultiLineLabel multiLineLabel, StringBuffer stringBuffer, int n) {
        String string = this.getStringResource(stringBuffer, "text", n);
        if (string != null) {
            multiLineLabel.setPreferredAspectRatio(8.0f);
            multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
            multiLineLabel.setText(string);
        }
    }

    protected TableColumnModel getHeaders(StringBuffer stringBuffer, int n) {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        int n2 = 0;
        String string = this.getStringResource(stringBuffer, new Integer(n2).toString(), n);
        while (string != null) {
            TableColumn tableColumn = new TableColumn();
            tableColumn.setHeaderValue(string);
            defaultTableColumnModel.addColumn(tableColumn);
            string = this.getStringResource(stringBuffer, new Integer(++n2).toString(), n);
        }
        if (defaultTableColumnModel.getColumnCount() != 0) {
            return defaultTableColumnModel;
        }
        return null;
    }

    private String handleGetString(ResourceBundle[] resourceBundleArray, String string) {
        return (String)this.handleGetObject(resourceBundleArray, string);
    }

    private Object handleGetObject(ResourceBundle[] resourceBundleArray, String string) {
        try {
            int n = 0;
            while (n < resourceBundleArray.length) {
                ResourceBundle resourceBundle = resourceBundleArray[n];
                if (resourceBundle != null) {
                    if (resourceBundle.getClass() == this.getClass()) {
                        Object object = ((ResourcePicker)resourceBundle).handleGetObject(string);
                        return object;
                    }
                    Object object = s_handleGetObject.invoke((Object)resourceBundle, string);
                    if (object != null) {
                        Object object2 = object;
                        return object2;
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected Object handleGetObject(String string) {
        Object object = this.handleGetObject(this.m_resource, string);
        if (object == null) {
            object = this.handleGetObject(this.m_defaultRes, string);
        }
        return object;
    }

    public Enumeration getKeys() {
        if (this.m_keyList == null) {
            EnumerationStack enumerationStack = new EnumerationStack();
            enumerationStack.push(this.m_defaultRes[0].getKeys());
            enumerationStack.push(this.m_resource[0].getKeys());
            this.m_keyList = new Vector();
            while (enumerationStack.hasMoreElements()) {
                Object object = enumerationStack.nextElement();
                if (this.m_keyList.contains(object)) continue;
                this.m_keyList.addElement(object);
            }
        }
        return this.m_keyList.elements();
    }

    private String redirectIfRequired(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.startsWith(s_INDIRECTION)) {
                String string2 = string.substring(2, string.length());
                String string3 = (String)this.handleGetObject(string2);
                return string3;
            }
        }
        catch (StackOverflowError stackOverflowError) {
            stackOverflowError.printStackTrace();
            String string4 = string;
            return string4;
        }
        return string;
    }

    public String getStringResource(String string, String string2, Object[] objectArray) {
        return this.formatString(this.getStringResource(string, string2), objectArray);
    }

    public String getStringResource(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string3 = stringBuffer.append('.').append(string2).toString();
        String string4 = this.redirectIfRequired(this.handleGetString(this.m_resource, string3));
        if (string4 == null) {
            string4 = this.redirectIfRequired(this.handleGetString(this.m_defaultRes, string3));
        }
        return string4;
    }

    public String getStringResource(String string, StringBuffer stringBuffer, String string2) {
        int n = stringBuffer.length() - string.length();
        return this.getStringResource(stringBuffer.append('.').append(string2), "", n);
    }

    public String getStringResource(StringBuffer stringBuffer, String string, int n) {
        String string2;
        int n2 = stringBuffer.length();
        String string3 = stringBuffer.append(string).toString();
        try {
            string2 = this.redirectIfRequired(this.handleGetString(this.m_resource, string3));
            if (string2 == null) {
                if (n <= 0) {
                    String string4 = this.redirectIfRequired(this.handleGetString(this.m_defaultRes, string3));
                    stringBuffer.setLength(n2);
                    return string4;
                }
                String string5 = string3.substring(n);
                string2 = this.redirectIfRequired(this.handleGetString(this.m_defaultRes, string5));
                if (string2 == null && (string2 = this.redirectIfRequired(this.handleGetString(this.m_resource, string5))) == null) {
                    string2 = this.redirectIfRequired(this.handleGetString(this.m_defaultRes, string3));
                }
            }
        }
        finally {
            stringBuffer.setLength(n2);
        }
        return string2;
    }

    public String getStringResource(String string) {
        return this.redirectIfRequired((String)this.handleGetObject(string));
    }

    public Icon getImage(String string) {
        return this.getImageResource(this.getString(string));
    }

    public ImageIcon getImageResource(String string) {
        if (string == null || string == "") {
            return null;
        }
        ImageIcon imageIcon = this.getCachedImage(string);
        if (imageIcon == null) {
            imageIcon = this.loadImageResourceFromPicker(this.m_resource, string);
            if (imageIcon != null) {
                return imageIcon;
            }
            if (this.m_defaultRes[0] instanceof ResourcePicker) {
                return ((ResourcePicker)this.m_defaultRes[0]).getImageResource(string);
            }
            imageIcon = this.loadImageResourceFromPicker(this.m_defaultRes, string);
            if (imageIcon != null) {
                return imageIcon;
            }
            return null;
        }
        return imageIcon;
    }

    private ImageIcon loadImageResourceFromPicker(ResourceBundle[] resourceBundleArray, String string) {
        ImageIcon imageIcon;
        URL uRL = resourceBundleArray[0].getClass().getResource(string);
        if (uRL != null && (imageIcon = this.loadImageFromURL(uRL)) != null) {
            this.cacheImage(string, imageIcon);
            return imageIcon;
        }
        return null;
    }

    private ImageIcon loadImageFromURL(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && ((imageIcon = new ImageIcon(uRL)).getImageLoadStatus() & 9) > 0) {
            return imageIcon;
        }
        return null;
    }

    private ImageIcon getCachedImage(String string) {
        if (this.m_imageCache == null) {
            return null;
        }
        return (ImageIcon)this.m_imageCache.get(string);
    }

    private void cacheImage(String string, ImageIcon imageIcon) {
        if (this.m_imageCache == null) {
            this.m_imageCache = new HashMap();
        }
        this.m_imageCache.put(string, imageIcon);
    }

    public static final ResourcePicker getPicker(Object object) {
        return ResourcePicker.getPicker(object.getClass());
    }

    public static final ResourcePicker getPicker(Class clazz) {
        String string = clazz.getPackage().getName();
        ResourcePicker resourcePicker = (ResourcePicker)s_pickers.get(string);
        if (resourcePicker != null) {
            return resourcePicker;
        }
        resourcePicker = new ResourcePicker(clazz);
        s_pickers.put(string, resourcePicker);
        return resourcePicker;
    }

    public static final ResourcePicker get() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        try {
            Class<?> clazz = Class.forName(stackTraceElementArray[1].getClassName());
            ResourcePicker resourcePicker = ResourcePicker.getPicker(clazz);
            return resourcePicker;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    private static final ResourceBundle[] getResources(ResourceBundle resourceBundle) {
        ResourceBundle[] resourceBundleArray = new ResourceBundle[4];
        int n = 0;
        while (n < 4) {
            if (resourceBundle == null) break;
            resourceBundleArray[n] = resourceBundle;
            try {
                resourceBundle = (ResourceBundle)s_parentField.get(resourceBundle);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                break;
            }
            ++n;
        }
        return resourceBundleArray;
    }

    public static interface ResourceBase {
    }

    public static interface ResourceFree {
    }

    public final class 1
    extends AbstractAction {
        private final /* synthetic */ AbstractButton v$finalButton;
        final /* synthetic */ ResourcePicker this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.v$finalButton.doClick();
        }

        public 1(ResourcePicker resourcePicker, AbstractButton abstractButton) {
            this.v$finalButton = abstractButton;
            this.this$0 = resourcePicker;
        }
    }
}

