/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class SwingUtils {
    public static final String STARTUP_WINDOW_KEY = "javatools.startup.window";
    public static final String MAIN_WINDOW_KEY = "javatools.main.window";
    public static final String PROGRAM_NAME_KEY = "javatools.program.name";
    public static final String PROGRAM_SHORT_NAME_KEY = "javatools.program.short.name";
    private static final boolean HAS_BUG_4307604 = true;
    private static final String SWING_AATEXT_PROPERTY = "swing.aatext";
    private static final boolean useAAText;

    static {
        String string = System.getProperty("java.version");
        if (!(string == null || string.startsWith("1.0") || string.startsWith("1.1") || string.startsWith("1.2") || string.startsWith("1.3") || string.startsWith("1.4"))) {
            String string2 = System.getProperty(SWING_AATEXT_PROPERTY, "false");
            useAAText = Boolean.valueOf(string2);
        } else {
            useAAText = false;
        }
    }

    private SwingUtils() {
    }

    public static Frame findFrame(Component component) {
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
    }

    public static Frame getMainWindow() {
        return SwingUtils.getFrame(MAIN_WINDOW_KEY, true);
    }

    public static Frame getStartupWindow() {
        return SwingUtils.getFrame(STARTUP_WINDOW_KEY, false);
    }

    public static Frame getToplevelWindow() {
        Frame frame = null;
        Frame frame2 = SwingUtils.getFrame(MAIN_WINDOW_KEY, false);
        if (frame2 != null) {
            frame = frame2;
            if (!frame2.isVisible() && (frame2 = SwingUtils.getFrame(STARTUP_WINDOW_KEY, false)) != null) {
                frame2.setVisible(true);
                if ((frame2.getState() & 1) != 0) {
                    frame2.setState(0);
                }
                frame2.toFront();
                frame = frame2;
            }
        } else {
            frame2 = SwingUtils.getFrame(STARTUP_WINDOW_KEY, true);
            if (frame2 != null) {
                frame2.setVisible(true);
                if ((frame2.getState() & 1) != 0) {
                    frame2.setState(0);
                }
                frame2.toFront();
                frame = frame2;
            }
        }
        return frame;
    }

    private static Frame getFrame(String string, boolean bl) {
        Frame[] frameArray = Frame.getFrames();
        if (frameArray != null) {
            int n = frameArray.length;
            Frame frame = null;
            int n2 = 0;
            while (n2 < n) {
                JFrame jFrame;
                Frame frame2 = frameArray[n2];
                if (frame == null && frame2 != null) {
                    frame = frame2;
                }
                if (frame2 instanceof JFrame && Boolean.TRUE.equals((jFrame = (JFrame)frame2).getRootPane().getClientProperty(string))) {
                    return jFrame;
                }
                ++n2;
            }
            if (frame != null && bl) {
                return frame;
            }
        }
        return null;
    }

    public static void setMainWindow(JFrame jFrame) {
        Frame frame = SwingUtils.getFrame(MAIN_WINDOW_KEY, false);
        if (frame != jFrame) {
            if (frame instanceof JFrame) {
                ((JFrame)frame).getRootPane().putClientProperty(MAIN_WINDOW_KEY, null);
            }
            if (jFrame != null) {
                jFrame.getRootPane().putClientProperty(MAIN_WINDOW_KEY, Boolean.TRUE);
            }
        }
    }

    public static void setStartupWindow(JFrame jFrame) {
        Frame frame = SwingUtils.getStartupWindow();
        if (frame != jFrame) {
            if (frame instanceof JFrame) {
                ((JFrame)frame).getRootPane().putClientProperty(STARTUP_WINDOW_KEY, null);
            }
            if (jFrame != null) {
                jFrame.getRootPane().putClientProperty(STARTUP_WINDOW_KEY, Boolean.TRUE);
            }
        }
    }

    private static String getStringClientProperty(String string) {
        String string2 = null;
        Frame frame = SwingUtils.getMainWindow();
        if (frame instanceof JFrame) {
            string2 = (String)((JFrame)frame).getRootPane().getClientProperty(string);
        }
        return string2 != null ? string2 : "";
    }

    public static String getProgramName() {
        return SwingUtils.getStringClientProperty(PROGRAM_NAME_KEY);
    }

    public static void setProgramName(String string) {
        SwingUtils.setStringClientProperty(PROGRAM_NAME_KEY, string);
    }

    private static void setStringClientProperty(String string, String string2) {
        Frame frame = SwingUtils.getMainWindow();
        if (frame instanceof JFrame) {
            ((JFrame)frame).getRootPane().putClientProperty(string, string2);
        }
    }

    public static String getProgramShortName() {
        return SwingUtils.getStringClientProperty(PROGRAM_SHORT_NAME_KEY);
    }

    public static void setProgramShortName(String string) {
        SwingUtils.setStringClientProperty(PROGRAM_SHORT_NAME_KEY, string);
    }

    public static Dialog getAncestorDialog(Component component) {
        return component != null ? (component instanceof Dialog ? (Dialog)component : (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, component)) : null;
    }

    public static Frame getAncestorFrame(Component component) {
        return component != null ? (component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component)) : null;
    }

    public static void removeKeyStrokesFromInputMaps(JComponent jComponent, KeyStroke[] keyStrokeArray) {
        SwingUtils.removeKeyStrokesFromInputMap(jComponent, keyStrokeArray, 1);
        SwingUtils.removeKeyStrokesFromInputMap(jComponent, keyStrokeArray, 0);
        SwingUtils.removeKeyStrokesFromInputMap(jComponent, keyStrokeArray, 2);
    }

    public static void removeKeyStrokesFromInputMap(JComponent jComponent, KeyStroke[] keyStrokeArray, int n) {
        InputMap inputMap = SwingUtilities.getUIInputMap(jComponent, n);
        if (inputMap == null) {
            return;
        }
        int n2 = 0;
        while (n2 < keyStrokeArray.length) {
            KeyStroke keyStroke = keyStrokeArray[n2];
            if (keyStroke != null) {
                inputMap.remove(keyStroke);
            }
            ++n2;
        }
        SwingUtilities.replaceUIInputMap(jComponent, n, inputMap);
    }

    public static boolean useTextAntialiasing() {
        return useAAText;
    }

    private static boolean drawTextAntialiased(Graphics graphics) {
        return SwingUtils.useTextAntialiasing() && graphics != null && graphics instanceof Graphics2D;
    }

    public static void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        if (n2 <= 0) {
            return;
        }
        if (SwingUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawChars(cArray, n, n2, n3, n4);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawChars(cArray, n, n2, n3, n4);
        }
    }

    public static void drawString(Graphics graphics, AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if (attributedCharacterIterator == null) {
            return;
        }
        if (SwingUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
            textLayout.draw(graphics2D, n, n2);
        } else {
            graphics.drawString(attributedCharacterIterator, n, n2);
        }
    }

    public static void drawString(Graphics graphics, String string, int n, int n2) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (SwingUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawString(string, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    public static void drawString(Graphics2D graphics2D, String string, float f, float f2) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (SwingUtils.useTextAntialiasing()) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            SwingUtils.drawG2DString(graphics2D, string, f, f2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            SwingUtils.drawG2DString(graphics2D, string, f, f2);
        }
    }

    private static void drawG2DString(Graphics2D graphics2D, String string, float f, float f2) {
        graphics2D.drawString(string, (int)f, (int)f2);
    }
}

