/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

public class SynchronizedQueue {
    private boolean enabled;
    private int get;
    private int put;
    private Object[] objects;

    void $init$() {
        this.enabled = true;
        this.get = 0;
        this.put = 0;
        this.objects = new Object[128];
    }

    public synchronized void add(Object object) {
        boolean bl;
        if (object == null) {
            throw new NullPointerException("adding null");
        }
        if (!this.enabled) {
            return;
        }
        boolean bl2 = bl = this.objects[this.get] == null;
        if (this.objects[this.put] != null) {
            Object[] objectArray = new Object[this.objects.length * 2];
            System.arraycopy(this.objects, this.get, objectArray, 0, this.objects.length - this.get);
            System.arraycopy(this.objects, 0, objectArray, this.objects.length - this.get, this.get);
            this.get = 0;
            this.put = this.objects.length;
            this.objects = objectArray;
        }
        this.objects[this.put] = object;
        if (++this.put == this.objects.length) {
            this.put = 0;
        }
        if (bl) {
            this.notify();
        }
    }

    public synchronized Object remove() throws InterruptedException {
        if (this.objects[this.get] == null) {
            this.wait();
        }
        Object object = this.objects[this.get];
        this.objects[this.get] = null;
        if (++this.get == this.objects.length) {
            this.get = 0;
        }
        return object;
    }

    public synchronized Object remove(long l) throws InterruptedException {
        Object object;
        if (this.objects[this.get] == null) {
            this.wait(l);
        }
        if ((object = this.objects[this.get]) != null) {
            this.objects[this.get] = null;
            if (++this.get == this.objects.length) {
                this.get = 0;
            }
        }
        return object;
    }

    public synchronized void clear() {
        this.get = 0;
        this.put = 0;
        this.objects = new Object[128];
    }

    public synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized boolean isEmpty() {
        return this.objects[this.get] == null;
    }

    public synchronized Object first() {
        return this.objects[this.get];
    }

    public synchronized Object last() {
        return this.objects[this.put > 0 ? this.put - 1 : this.objects.length - 1];
    }

    public SynchronizedQueue() {
        this.$init$();
    }
}

