/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.HashMap;
import java.util.StringTokenizer;

public class Version
implements Comparable {
    private static final HashMap _convertCache = new HashMap(100);
    private final int[] _numbers;
    private final String _versionLabel;

    public Version(String string) throws NumberFormatException {
        this._versionLabel = string;
        this._numbers = this.convert(string);
    }

    public Version(int[] nArray) {
        this._numbers = nArray;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(String.valueOf(nArray[n]));
            ++n;
        }
        this._versionLabel = stringBuffer.toString();
    }

    public int[] toIntArray() {
        int[] nArray = new int[this._numbers.length];
        System.arraycopy(this._numbers, 0, nArray, 0, this._numbers.length);
        return nArray;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        int[] nArray = ((Version)object)._numbers;
        int n = this._numbers.length;
        int n2 = nArray.length;
        int n3 = Math.max(n, n2);
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = n4 < n ? this._numbers[n4] : 0;
            int n7 = n5 = n4 < n2 ? nArray[n4] : 0;
            if (n6 != n5) {
                return n6 - n5;
            }
            ++n4;
        }
        return 0;
    }

    public String toString() {
        return this._versionLabel;
    }

    public String toCanonicalString() {
        int n = this._numbers.length;
        StringBuffer stringBuffer = new StringBuffer(n * 3).append(this._numbers[0]);
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append('.');
            stringBuffer.append(this._numbers[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        int n = this._numbers.length;
        if (n != version._numbers.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this._numbers[n2] != version._numbers[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n = 925295;
        int n2 = this._numbers.length;
        int n3 = 0;
        while (n3 < n2) {
            n = 37 * n + n3;
            ++n3;
        }
        return n;
    }

    private int[] convert(String string) throws NumberFormatException {
        int[] nArray = (int[])_convertCache.get(string);
        if (nArray != null) {
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        int n = stringTokenizer.countTokens() + 1;
        if (n % 2 != 0) {
            throw new NumberFormatException(" Malformed version specification: `" + string + "`.");
        }
        nArray = new int[n / 2];
        boolean bl = true;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                bl = false;
                int n3 = Integer.parseInt(string2);
                if (n3 < 0) {
                    throw new NumberFormatException("Malformed version specification: `" + n3 + "`." + "Version number must be > 0.");
                }
                nArray[n2++] = n3;
                continue;
            }
            bl = true;
        }
        return nArray;
    }
}

