/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class XSLTBuilder {
    private String m_outputDirectory;
    private String m_driverFile;
    private String m_baseDir;

    private XSLTBuilder(String string, String string2) {
        this.m_outputDirectory = string == null ? "" : string + "/";
        this.m_driverFile = string2;
    }

    private void transform() throws Exception {
        Driver driver = new Driver(this.m_driverFile);
        this.m_baseDir = driver.getBaseDir();
        Iterator iterator = driver.getStylesheets();
        while (iterator.hasNext()) {
            StylesheetInfo stylesheetInfo = (StylesheetInfo)iterator.next();
            this.transform(stylesheetInfo, driver.getSourceFiles(stylesheetInfo));
        }
    }

    private void clean() throws Exception {
        Driver driver = new Driver(this.m_driverFile);
        Iterator iterator = driver.getStylesheets();
        while (iterator.hasNext()) {
            StylesheetInfo stylesheetInfo = (StylesheetInfo)iterator.next();
            Iterator iterator2 = driver.getSourceFiles(stylesheetInfo);
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                String string2 = this.getOutputFilename(string, stylesheetInfo.extension);
                File file = new File(this.m_baseDir, string2);
                if (!file.exists() || file.delete()) continue;
                System.out.println("Can't delete " + file);
            }
        }
    }

    private String getOutputFilename(String string, String string2) {
        int n = string.indexOf(46);
        return this.m_outputDirectory + string.substring(0, n) + "." + string2;
    }

    private void transform(StylesheetInfo stylesheetInfo, Iterator iterator) throws Exception {
        System.out.println("Transforming " + stylesheetInfo.description);
        XSLProcessor xSLProcessor = new XSLProcessor();
        FileReader fileReader = new FileReader(new File(this.m_baseDir, stylesheetInfo.filename));
        XSLStylesheet xSLStylesheet = xSLProcessor.newXSLStylesheet((Reader)fileReader);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getOutputFilename(string, stylesheetInfo.extension);
            System.out.println(string2);
            FileReader fileReader2 = new FileReader(new File(this.m_baseDir, string));
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(new InputSource(fileReader2));
            File file = new File(string2);
            file.getParentFile().mkdirs();
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            xSLProcessor.processXSL(xSLStylesheet, dOMParser.getDocument(), printWriter);
        }
    }

    private static void die() {
        System.err.println("Usage:");
        System.err.println(XSLTBuilder.class.getName() + " [-clean] [-d <output directory>] <driver-filename>");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        boolean bl = false;
        String string = null;
        if (n == stringArray.length) {
            XSLTBuilder.die();
        }
        if ("-clean".equalsIgnoreCase(stringArray[n])) {
            ++n;
            bl = true;
        }
        if (n == stringArray.length) {
            XSLTBuilder.die();
        }
        if ("-d".equalsIgnoreCase(stringArray[n])) {
            if (++n == stringArray.length) {
                XSLTBuilder.die();
            }
            string = stringArray[n++];
        }
        if (n == stringArray.length) {
            XSLTBuilder.die();
        }
        String string2 = stringArray[n++];
        if (n > stringArray.length) {
            XSLTBuilder.die();
        }
        XSLTBuilder xSLTBuilder = new XSLTBuilder(string, string2);
        if (bl) {
            xSLTBuilder.clean();
        } else {
            try {
                xSLTBuilder.transform();
            }
            catch (Exception exception) {
                System.err.println("Failed to drive XSLT transform from " + string2);
                System.err.println(exception.getMessage());
            }
        }
    }

    private class StylesheetInfo {
        public String filename;
        public String description;
        public String extension;

        private StylesheetInfo() {
        }

        StylesheetInfo(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Driver {
        private HashMap m_stylesheets;
        private String m_baseDir;

        void $init$() {
            this.m_stylesheets = new HashMap();
            this.m_baseDir = null;
        }

        public Driver(String string) throws Exception {
            this.$init$();
            FileInputStream fileInputStream = new FileInputStream(string);
            this.parseDriverFile(new InputSource(fileInputStream));
        }

        public String getBaseDir() {
            return this.m_baseDir == null ? "." : this.m_baseDir;
        }

        private void parseDriverFile(InputSource inputSource) throws Exception {
            Node node;
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Element element = xMLDocument.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("baseDir");
            int n = 0;
            if (n < nodeList.getLength()) {
                node = nodeList.item(n);
                this.m_baseDir = ((Text)node.getFirstChild()).getData();
            }
            nodeList = element.getElementsByTagName("xsl-stylesheet");
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                node = nodeList.item(n2);
                StylesheetInfo stylesheetInfo = new StylesheetInfo(null);
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = namedNodeMap.getNamedItem("ref");
                if (node2 != null) {
                    stylesheetInfo.filename = node2.getNodeValue().trim();
                } else {
                    System.err.println("Warning: Missing ref attribute for xsl-stylesheet");
                }
                node2 = namedNodeMap.getNamedItem("description");
                stylesheetInfo.description = node2 != null ? node2.getNodeValue().trim() : "Untitled XSL Transform";
                node2 = namedNodeMap.getNamedItem("ext");
                if (node2 != null) {
                    stylesheetInfo.extension = node2.getNodeValue().trim();
                } else {
                    System.err.println("Warning: Missing ext attribute for xsl-stylesheet");
                }
                NodeList nodeList2 = node.getChildNodes();
                ArrayList<String> arrayList = new ArrayList<String>(nodeList2.getLength());
                int n3 = 0;
                while (n3 < nodeList2.getLength()) {
                    Node node3 = nodeList2.item(n3);
                    if (node3 instanceof Element && "xml-file".equals((element = (Element)node3).getTagName())) {
                        arrayList.add(element.getAttributes().getNamedItem("ref").getNodeValue().trim());
                    }
                    ++n3;
                }
                this.m_stylesheets.put(stylesheetInfo, arrayList);
                ++n2;
            }
        }

        public Iterator getStylesheets() {
            return this.m_stylesheets.keySet().iterator();
        }

        public Iterator getSourceFiles(StylesheetInfo stylesheetInfo) {
            ArrayList arrayList = (ArrayList)this.m_stylesheets.get(stylesheetInfo);
            return arrayList.iterator();
        }
    }
}

