/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.javatools.xml.bind.BindingUtil;
import oracle.javatools.xml.bind.DOMBindingRuntime;
import oracle.javatools.xml.bind.ElementFilter;
import oracle.javatools.xml.bind.ElementProxy;
import oracle.javatools.xml.bind.NodeListImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;
import oracle.javatools.xml.bind.XMLName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class BindingContext
extends BindingUtil {
    final DOMBindingRuntime _rt;
    final Class _contextIntf;
    final Element _contextElem;
    final int _indentDepth;
    final int _type;
    static final /* synthetic */ boolean $assertionsDisabled;

    BindingContext(DOMBindingRuntime dOMBindingRuntime, Class clazz, Element element, int n) {
        this(dOMBindingRuntime, clazz, element, n, 0);
    }

    BindingContext(DOMBindingRuntime dOMBindingRuntime, Class clazz, Element element, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this._rt = dOMBindingRuntime;
        this._contextIntf = clazz;
        this._contextElem = element;
        this._indentDepth = n;
        this._type = n2;
    }

    BindingContext(BindingContext bindingContext) {
        this._rt = bindingContext._rt;
        this._contextIntf = bindingContext._contextIntf;
        this._contextElem = bindingContext._contextElem;
        this._indentDepth = bindingContext._indentDepth;
        this._type = bindingContext._type;
    }

    void setElement(Element element, Element element2, XMLBindingInfo xMLBindingInfo) {
        if (element2 != null) {
            if (element == null) {
                BindingContext.deleteElement(element2);
            } else if (element != element2) {
                this._contextElem.replaceChild(element, element2);
            }
        } else if (element != null) {
            this.insertElem(xMLBindingInfo, element);
        }
    }

    void insertElem(XMLBindingInfo xMLBindingInfo, Element element) {
        NodeList nodeList = this._contextElem.getChildNodes();
        int n = nodeList.getLength();
        Element element2 = null;
        Element element3 = null;
        int n2 = 0;
        while (n2 < n) {
            Node node;
            if (element3 == null && (node = nodeList.item(n2)).getNodeType() == 1) {
                element3 = (Element)node;
            }
            if (element3 != null) {
                if (this.insertNewElement(element, element2, element3, xMLBindingInfo)) break;
                element2 = element3;
                element3 = null;
            }
            ++n2;
        }
        if (n2 == n) {
            this.insertNewElement(element, element2, element3, xMLBindingInfo);
        }
    }

    private boolean insertNewElement(Element element, Element element2, Element element3, XMLBindingInfo xMLBindingInfo) {
        String string;
        String string2;
        String string3;
        String string4 = BindingContext.getNamespaceURI(element2);
        if (this._rt._binding.insertBetween(this._contextIntf, string4, string3 = BindingContext.getLocalName(element2), string2 = BindingContext.getNamespaceURI(element3), string = BindingContext.getLocalName(element3), xMLBindingInfo._nsURI, xMLBindingInfo._localName)) {
            this.insertElement(element, element3);
            return true;
        }
        return false;
    }

    void insertElement(Element element, Node node) {
        boolean bl = this._contextElem.getChildNodes().getLength() == 0;
        Node node2 = BindingContext.findInsertionNode(this._contextElem, node);
        String string = this.whitespace(true, false);
        if (string != null && string.length() > 0) {
            this._contextElem.insertBefore(this._rt._document.createTextNode(string), node2);
        }
        this._contextElem.insertBefore(element, node2);
        if (bl) {
            if (node2 != null) {
                throw new RuntimeException("Assertion failed -- beforeThisNode is non-null.");
            }
            String string2 = this.whitespace(true, true);
            if (string2 != null && string2.length() > 0) {
                this._contextElem.insertBefore(this._rt._document.createTextNode(string2), node2);
            }
        }
    }

    Object createProxy(Element element, Class clazz, int n) {
        BindingContext bindingContext = new BindingContext(this._rt, clazz, element, this._indentDepth + 1, n);
        ElementProxy elementProxy = new ElementProxy(bindingContext);
        return BindingContext.createProxy(clazz, elementProxy);
    }

    Object callCreate(XMLBindingInfo xMLBindingInfo, Method method) {
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return this.callCreateImpl(xMLBindingInfo, clazz);
        }
        throw new IllegalStateException("Create method must return a non-void proxy type");
    }

    Object callCreateImpl(XMLBindingInfo xMLBindingInfo, Class clazz) {
        Element element = this.createElement(xMLBindingInfo);
        return this.createProxy(element, clazz, xMLBindingInfo.getType());
    }

    Element createElement(XMLName xMLName) {
        String string = this.findPrefix(xMLName._nsURI);
        return this._rt._document.createElementNS(xMLName._nsURI, xMLName.getQname(string));
    }

    String findPrefix(String string) {
        if (string == null) {
            return null;
        }
        if (XMLName.isDefaultNamespace(this._contextElem, string)) {
            return "";
        }
        return XMLName.lookupPrefix(this._contextElem, string);
    }

    static NodeListImpl getChildrenByQName(Element element, String string, String string2) {
        return BindingContext.getChildrenByQName(element, string, string2, new ElementFilter());
    }

    static {
        $assertionsDisabled = BindingContext.class.desiredAssertionStatus() ^ true;
    }

    static NodeListImpl getChildrenByQName(Element element, String string, String string2, ElementFilter elementFilter) {
        if (!$assertionsDisabled && elementFilter == null) {
            throw new AssertionError();
        }
        NodeListImpl nodeListImpl = new NodeListImpl();
        if (element != null) {
            Node node = element.getFirstChild();
            while (node != null) {
                Element element2;
                if (node.getNodeType() == 1 && BindingContext.matches(element2 = (Element)node, string, string2) && elementFilter.accept(element2)) {
                    nodeListImpl.add(element2);
                }
                node = node.getNextSibling();
            }
        }
        return nodeListImpl;
    }

    static boolean matches(Element element, String string, String string2) {
        if (element != null) {
            return BindingContext.areEqual(string, element.getNamespaceURI()) && BindingContext.areEqual(string2, element.getLocalName());
        }
        return false;
    }

    static Element extractElementFromProxy(Object object) {
        InvocationHandler invocationHandler;
        InvocationHandler invocationHandler2 = invocationHandler = object != null ? Proxy.getInvocationHandler(object) : null;
        if (invocationHandler != null) {
            try {
                Element element = ((ElementProxy)invocationHandler)._bc._contextElem;
                return element;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Values must be created by the binding runtime.");
            }
        }
        return null;
    }

    static Object createProxy(Class clazz, InvocationHandler invocationHandler) {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
    }

    static Text findFirstTextNodeInChildElement(Element element, XMLBindingInfo xMLBindingInfo, boolean bl) {
        NodeListImpl nodeListImpl = BindingContext.getChildrenByQName(element, xMLBindingInfo._nsURI, xMLBindingInfo._localName);
        if (nodeListImpl.getLength() > 0) {
            Element element2 = (Element)nodeListImpl.item(0);
            return BindingContext.findFirstTextNode(element2, bl);
        }
        return null;
    }

    static Text findFirstTextNode(Element element, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(0);
            if (node.getNodeType() == 3) {
                return (Text)node;
            }
            ++n2;
        }
        if (bl) {
            Text text = element.getOwnerDocument().createTextNode("");
            element.appendChild(text);
            return text;
        }
        return null;
    }

    static void deleteElement(Element element) {
        Node node = element.getParentNode();
        BindingContext.deleteIfWhitespaceTextNode(node, element.getPreviousSibling());
        node.removeChild(element);
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 1) {
            BindingContext.deleteIfWhitespaceTextNode(node, nodeList.item(0));
        }
    }

    static String obj2String(Object object) {
        return object != null ? object.toString() : null;
    }

    private String whitespace(boolean bl, boolean bl2) {
        if (!this._rt._enableWhitespace) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this._rt._eol);
        }
        int n = this._indentDepth;
        if (bl2) {
            --n;
        }
        if (n > 0) {
            stringBuffer.append(this._rt.getIndent(n));
        }
        return stringBuffer.toString();
    }

    private static boolean isWhitespaceTextNode(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    private static void deleteIfWhitespaceTextNode(Node node, Node node2) {
        if (BindingContext.isWhitespaceTextNode(node2)) {
            node.removeChild(node2);
        }
    }

    private static Node findInsertionNode(Element element, Node node) {
        Node node2;
        Node node3 = node2 = node != null ? node.getPreviousSibling() : element.getLastChild();
        if (BindingContext.isWhitespaceTextNode(node2)) {
            String string;
            Node node4;
            Node node5 = node2.getPreviousSibling();
            if (BindingContext.isCommentNode(node5) && BindingContext.isWhitespaceTextNode(node4 = node5.getPreviousSibling()) && ((string = node4.getNodeValue()).indexOf(13) >= 0 || string.indexOf(10) >= 0)) {
                return node4;
            }
            return node2;
        }
        return node;
    }

    private static boolean isCommentNode(Node node) {
        return node != null && node.getNodeType() == 8;
    }

    private static String getNamespaceURI(Element element) {
        return element != null ? element.getNamespaceURI() : null;
    }

    private static String getLocalName(Element element) {
        return element != null ? element.getLocalName() : null;
    }
}

