/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.ElementProxy;
import oracle.javatools.xml.bind.IndentPrefs;
import oracle.javatools.xml.bind.XMLBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMBindingRuntime {
    private static IndentPrefs _defaultIndentPrefs = new IndentPrefs();
    final Document _document;
    private final ElementProxy _handler;
    final XMLBinding _binding;
    private final Class _rootInterface;
    private Object _proxy;
    final String _eol;
    boolean _enableWhitespace;
    private IndentPrefs _indent;

    void $init$() {
        this._eol = "\n";
        this._enableWhitespace = true;
    }

    public DOMBindingRuntime(Document document, XMLBinding xMLBinding) {
        this.$init$();
        DOMBindingRuntime.checkNull(document, "document must not be null");
        DOMBindingRuntime.checkNull(xMLBinding, "binding must not be null");
        this._document = document;
        Element element = document.getDocumentElement();
        BindingContext bindingContext = new BindingContext(this, xMLBinding.getRootInterface(), element, 1);
        this._handler = new ElementProxy(bindingContext);
        this._binding = xMLBinding;
        this._rootInterface = xMLBinding.getRootInterface();
        DOMBindingRuntime.checkNull(this._rootInterface, "root interface must not be null");
    }

    public static Element getBoundElement(Object object) {
        if (object != null) {
            try {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
                if (invocationHandler instanceof ElementProxy) {
                    Element element = ((ElementProxy)invocationHandler)._bc._contextElem;
                    return element;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void checkNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    public static void setDefaultIndentPrefs(IndentPrefs indentPrefs) {
        if (indentPrefs != null) {
            _defaultIndentPrefs = indentPrefs;
        }
    }

    public void setIndentWidth(int n, boolean bl) {
        this.setIndentWidth(n, bl, 8);
    }

    public void setIndentWidth(int n, boolean bl, int n2) {
        this._indent = new 1(this, n, bl, n2);
    }

    public void setEnableWhitespace(boolean bl) {
        this._enableWhitespace = bl;
    }

    char[] getIndent(int n) {
        if (n == 0 || this._indent.getWidth() == 0) {
            return new char[0];
        }
        int n2 = this._indent.getWidth();
        n2 = Math.max(n2, 0);
        n2 = Math.min(n2, 1000);
        int n3 = n * n2;
        int n4 = 0;
        if (!this._indent.getUseSpaces()) {
            int n5 = this._indent.getTabSize();
            if (n5 <= 0) {
                n5 = 8;
            }
            n4 = n3 / n5;
            n3 %= n5;
        }
        char[] cArray = new char[n4 + n3];
        int n6 = 0;
        while (n6 < n4) {
            cArray[n6] = 9;
            ++n6;
        }
        while (n6 < cArray.length) {
            cArray[n6] = 32;
            ++n6;
        }
        return cArray;
    }

    public Object getProxy() {
        if (this._proxy == null) {
            this._proxy = BindingContext.createProxy(this._rootInterface, this._handler);
        }
        if (this._indent == null) {
            this.setIndentWidth(_defaultIndentPrefs.getWidth(), _defaultIndentPrefs.getUseSpaces() ^ true, _defaultIndentPrefs.getTabSize());
        }
        return this._proxy;
    }

    public final class 1
    extends IndentPrefs {
        private final /* synthetic */ int v$width;
        private final /* synthetic */ boolean v$useTabs;
        private final /* synthetic */ int v$tabSize;
        final /* synthetic */ DOMBindingRuntime this$0;

        public int getWidth() {
            return this.v$width;
        }

        public boolean getUseSpaces() {
            return this.v$useTabs ^ true;
        }

        public int getTabSize() {
            return this.v$tabSize;
        }

        public 1(DOMBindingRuntime dOMBindingRuntime, int n, boolean bl, int n2) {
            this.v$tabSize = n2;
            this.v$useTabs = bl;
            this.v$width = n;
            this.this$0 = dOMBindingRuntime;
        }
    }
}

