/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.util.Iterator;
import javax.swing.event.EventListenerList;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.ElementFilter;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.javatools.xml.bind.XMLBindingInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class ElementListImpl
extends BindingContext
implements ElementList {
    final XMLBindingInfo _info;
    private final boolean _isStringType;
    private final ElementFilter _filter;
    private EventListenerList _elementListListeners;

    ElementListImpl(BindingContext bindingContext, XMLBindingInfo xMLBindingInfo, ElementFilter elementFilter) {
        super(bindingContext);
        this._info = xMLBindingInfo;
        this._isStringType = xMLBindingInfo != null && xMLBindingInfo._propertyType == String.class;
        this._filter = elementFilter != null ? elementFilter : new ElementFilter();
    }

    public void add(Object object) {
        XMLBindingInfo xMLBindingInfo = this.checkArgType(object);
        Element element = this.listExtractElementFromProxy(object);
        this.insertElem(xMLBindingInfo, element);
        if (this._elementListListeners != null) {
            int n = this.size() - 1;
            this.fireElementsAdded(n, n);
        }
    }

    public void add(int n, Object object) {
        NodeList nodeList = this.nodes();
        int n2 = nodeList.getLength();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            this.add(object);
        } else {
            this.checkArgType(object);
            Element element = this.listExtractElementFromProxy(object);
            Element element2 = (Element)nodeList.item(n);
            this.insertElement(element, element2);
            this.fireElementsAdded(n, n);
        }
    }

    public void addElementListListener(ElementListListener elementListListener) {
        if (this._elementListListeners == null) {
            this._elementListListeners = new EventListenerList();
        }
        this._elementListListeners.add(ElementListListener.class, elementListListener);
    }

    public void clear() {
        NodeList nodeList = this.nodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            ElementListImpl.deleteElement((Element)nodeList.item(n2));
            ++n2;
        }
        if (n > 0) {
            this.fireElementsRemoved(0, n - 1);
        }
    }

    public Object createElement() {
        return this.callCreateImpl(this._info);
    }

    public Class elementType() {
        return this._info._propertyType;
    }

    public Object get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        NodeList nodeList = this.nodes();
        if (n >= nodeList.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Element element = (Element)nodeList.item(n);
        return this.createProxy(element);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        NodeList nodeList = this.nodes();
        return new 1(this, nodeList);
    }

    public Object remove(int n) {
        Element element = (Element)this.nodes().item(n);
        return this.removeImpl(element, this.createProxy(element), n);
    }

    public void removeElementListListener(ElementListListener elementListListener) {
        if (this._elementListListeners != null) {
            this._elementListListeners.remove(ElementListListener.class, elementListListener);
        }
    }

    public Object set(int n, Object object) {
        Element element = (Element)this.nodes().item(n);
        XMLBindingInfo xMLBindingInfo = this.checkArgType(object);
        Element element2 = this.listExtractElementFromProxy(object);
        this.setElement(element2, element, xMLBindingInfo);
        this.fireElementsChanged(n, n);
        return this.createProxy(element);
    }

    public int size() {
        return this.nodes().getLength();
    }

    final ElementFilter getElementFilter() {
        return this._filter;
    }

    NodeList nodes() {
        return ElementListImpl.getChildrenByQName(this._contextElem, this._info._nsURI, this._info._localName, this.getElementFilter());
    }

    Object callCreateImpl(XMLBindingInfo xMLBindingInfo) {
        return this.callCreateImpl(xMLBindingInfo, xMLBindingInfo._propertyType);
    }

    private Object removeImpl(Element element, Object object, int n) {
        ElementListImpl.deleteElement(element);
        this.fireElementsRemoved(n, n);
        return object;
    }

    XMLBindingInfo checkArgType(Object object) {
        if (this._info._propertyType.isAssignableFrom(object.getClass())) {
            return this._info;
        }
        throw new ClassCastException("Wrong type passed to ElementList.");
    }

    Object createProxy(Element element) {
        if (this._isStringType) {
            return ElementListImpl.getTextValue(element);
        }
        return this.createProxy(element, this._info);
    }

    Object createProxy(Element element, XMLBindingInfo xMLBindingInfo) {
        return this.createProxy(element, xMLBindingInfo._propertyType, xMLBindingInfo.getType());
    }

    private Element listExtractElementFromProxy(Object object) {
        if (this._isStringType) {
            Element element = this.createElement(this._info);
            Text text = this._rt._document.createTextNode(object.toString());
            element.appendChild(text);
            return element;
        }
        return ElementListImpl.extractElementFromProxy(object);
    }

    private void fireElementsAdded(int n, int n2) {
        if (this._elementListListeners != null) {
            Object[] objectArray = this._elementListListeners.getListenerList();
            ElementListEvent elementListEvent = null;
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == ElementListListener.class) {
                    if (elementListEvent == null) {
                        elementListEvent = new ElementListEvent(this, n, n2);
                    }
                    try {
                        ((ElementListListener)objectArray[n3 + 1]).elementsAdded(elementListEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                n3 -= 2;
            }
        }
    }

    private void fireElementsRemoved(int n, int n2) {
        if (this._elementListListeners != null) {
            Object[] objectArray = this._elementListListeners.getListenerList();
            ElementListEvent elementListEvent = null;
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == ElementListListener.class) {
                    if (elementListEvent == null) {
                        elementListEvent = new ElementListEvent(this, n, n2);
                    }
                    try {
                        ((ElementListListener)objectArray[n3 + 1]).elementsRemoved(elementListEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                n3 -= 2;
            }
        }
    }

    private void fireElementsChanged(int n, int n2) {
        if (this._elementListListeners != null) {
            Object[] objectArray = this._elementListListeners.getListenerList();
            ElementListEvent elementListEvent = null;
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == ElementListListener.class) {
                    if (elementListEvent == null) {
                        elementListEvent = new ElementListEvent(this, n, n2);
                    }
                    try {
                        ((ElementListListener)objectArray[n3 + 1]).elementsChanged(elementListEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                n3 -= 2;
            }
        }
    }

    static Object mav$removeImpl(ElementListImpl elementListImpl, Element element, Object object, int n) {
        return elementListImpl.removeImpl(element, object, n);
    }

    final class 1
    implements Iterator {
        private final int _n;
        private int _i;
        private int _removeCount;
        private Element _elem;
        private Object _itemProxy;
        private final /* synthetic */ NodeList v$nodes;
        final /* synthetic */ ElementListImpl this$0;

        void $init$() {
            this._n = this.v$nodes.getLength();
            this._i = 0;
            this._removeCount = 0;
        }

        public boolean hasNext() {
            return this._i < this._n;
        }

        public Object next() {
            this._elem = (Element)this.v$nodes.item(this._i++);
            this._itemProxy = this.this$0.createProxy(this._elem);
            return this._itemProxy;
        }

        public void remove() {
            if (this._elem == null) {
                throw new IllegalStateException();
            }
            try {
                ElementListImpl.mav$removeImpl(this.this$0, this._elem, this._itemProxy, this._i - ++this._removeCount);
            }
            finally {
                this._elem = null;
                this._itemProxy = null;
            }
        }

        public 1(ElementListImpl elementListImpl, NodeList nodeList) {
            this.v$nodes = nodeList;
            this.this$0 = elementListImpl;
            this.$init$();
        }
    }
}

