/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.NodeListImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class GetImpl
extends XMLBindingInfo {
    private final int _xmlType;
    private transient BindingContext _bc;

    GetImpl(int n, String string) {
        this(n, null, null, string, null);
    }

    GetImpl(int n, String string, String string2) {
        this(n, string, null, string2, null);
    }

    GetImpl(int n, String string, String string2, String string3, Class clazz) {
        super(string, string2, string3, clazz);
        this._xmlType = n;
    }

    boolean isBindingValid(Method method) {
        return method.getParameterTypes().length == 0;
    }

    Object invoke(BindingContext bindingContext, Object object, Method method, Object[] objectArray) throws InvocationTargetException {
        this._bc = bindingContext;
        return this.callGetter(method);
    }

    private Object callGetter(Method method) {
        Class<?> clazz = method.getReturnType();
        if (clazz == String.class) {
            return this.callGetter_String();
        }
        if (clazz == Boolean.class) {
            return this.callGetter_Boolean();
        }
        if (clazz == Integer.class) {
            return this.callGetter_Integer();
        }
        return this.callGetterForUniqueElem(clazz);
    }

    private String callGetter_String() {
        switch (this._xmlType) {
            case 0: {
                Text text = BindingContext.findFirstTextNodeInChildElement(this._bc._contextElem, this, false);
                return text != null ? text.getNodeValue() : null;
            }
            case 1: {
                Attr attr = this._bc._contextElem.getAttributeNodeNS(this._nsURI, this._localName);
                return attr != null ? attr.getValue() : null;
            }
        }
        throw new IllegalStateException("Invalid XML type in XMLBindingInfo: " + this._xmlType);
    }

    private Boolean callGetter_Boolean() {
        String string = this.callGetter_String();
        return string != null ? Boolean.valueOf(string.trim()) : null;
    }

    private Integer callGetter_Integer() {
        String string = this.callGetter_String();
        return string != null ? Integer.valueOf(string.trim()) : null;
    }

    private Object callGetterForUniqueElem(Class clazz) {
        NodeListImpl nodeListImpl = BindingContext.getChildrenByQName(this._bc._contextElem, this._nsURI, this._localName);
        if (nodeListImpl.getLength() > 0) {
            Element element = (Element)nodeListImpl.item(0);
            return this._bc.createProxy(element, clazz, this.getType());
        }
        return null;
    }
}

