/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.ElementFilter;
import oracle.javatools.xml.bind.ElementListImpl;
import oracle.javatools.xml.bind.NodeListImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class MixedElementListImpl
extends ElementListImpl {
    private final XMLBindingInfo[] _listItemBindings;

    MixedElementListImpl(BindingContext bindingContext, XMLBindingInfo[] xMLBindingInfoArray) {
        this(bindingContext, xMLBindingInfoArray, null);
    }

    MixedElementListImpl(BindingContext bindingContext, XMLBindingInfo[] xMLBindingInfoArray, ElementFilter elementFilter) {
        super(bindingContext, null, elementFilter);
        this._listItemBindings = xMLBindingInfoArray;
    }

    public Object createElement() {
        throw new IllegalStateException("createElement() is unavailable when an ElementList contains elements of different names");
    }

    public Class elementType() {
        return null;
    }

    NodeList nodes() {
        NodeListImpl nodeListImpl = new NodeListImpl();
        Node node = this._contextElem.getFirstChild();
        ElementFilter elementFilter = this.getElementFilter();
        while (node != null) {
            Element element;
            if (node.getNodeType() == 1 && this.findMatchingBinding(element = (Element)node) != null && elementFilter.accept(element)) {
                nodeListImpl.add(element);
            }
            node = node.getNextSibling();
        }
        return nodeListImpl;
    }

    XMLBindingInfo checkArgType(Object object) {
        Class<?> clazz = object.getClass();
        int n = this._listItemBindings.length;
        int n2 = 0;
        while (n2 < n) {
            XMLBindingInfo xMLBindingInfo = this._listItemBindings[n2];
            if (xMLBindingInfo._propertyType.isAssignableFrom(clazz)) {
                return xMLBindingInfo;
            }
            ++n2;
        }
        throw new ClassCastException("Wrong type passed to ElementList.");
    }

    Object createProxy(Element element) {
        XMLBindingInfo xMLBindingInfo = this.findMatchingBinding(element);
        if (xMLBindingInfo != null) {
            return this.createProxy(element, xMLBindingInfo);
        }
        throw new IllegalStateException("No XML binding found for the element.");
    }

    private XMLBindingInfo findMatchingBinding(Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        int n = this._listItemBindings.length;
        int n2 = 0;
        while (n2 < n) {
            XMLBindingInfo xMLBindingInfo = this._listItemBindings[n2];
            if (MixedElementListImpl.areEqual(string2, xMLBindingInfo._localName) && MixedElementListImpl.areEqual(string, xMLBindingInfo._nsURI)) {
                return xMLBindingInfo;
            }
            ++n2;
        }
        return null;
    }
}

