/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.Method;
import oracle.javatools.xml.bind.BindingContext;
import oracle.javatools.xml.bind.NodeListImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

final class SetImpl
extends XMLBindingInfo {
    private final int _xmlType;
    private transient BindingContext _bc;

    SetImpl(int n, String string) {
        super(string);
        this._xmlType = n;
    }

    SetImpl(int n, String string, String string2, String string3) {
        super(string, string2, string3, null);
        this._xmlType = n;
    }

    Object invoke(BindingContext bindingContext, Object object, Method method, Object[] objectArray) {
        this._bc = bindingContext;
        this.callSetter(method.getParameterTypes()[0], objectArray[0]);
        return null;
    }

    void invoke(BindingContext bindingContext, Method method, Object object) {
        this._bc = bindingContext;
        this.callSetter(method.getReturnType(), object);
    }

    private void callSetter(Class clazz, Object object) {
        if (clazz == String.class) {
            this.callSetter_String(BindingContext.obj2String(object));
        } else if (clazz == Boolean.class) {
            this.callSetter_Boolean(object);
        } else if (clazz == Integer.class) {
            this.callSetter_Integer(object);
        } else {
            this.callSetterForUniqueElem(object);
        }
    }

    private void callSetterForUniqueElem(Object object) {
        Element element = BindingContext.extractElementFromProxy(object);
        NodeListImpl nodeListImpl = BindingContext.getChildrenByQName(this._bc._contextElem, this._nsURI, this._localName);
        Element element2 = nodeListImpl.getLength() > 0 ? (Element)nodeListImpl.item(0) : null;
        this._bc.setElement(element, element2, this);
    }

    private void callSetter_Boolean(Object object) {
        this.callSetter_String(BindingContext.obj2String(object));
    }

    private void callSetter_Integer(Object object) {
        this.callSetter_String(BindingContext.obj2String(object));
    }

    private void callSetter_String(String string) {
        switch (this._xmlType) {
            case 0: {
                this.insertChangeDeleteLeafElem(string);
                return;
            }
            case 1: {
                this.insertChangeDeleteAttr(string);
                return;
            }
        }
        throw new IllegalStateException("Invalid XML type in XMLBindingInfo: " + this._xmlType);
    }

    private void insertChangeDeleteLeafElem(String string) {
        boolean bl = string != null;
        Text text = BindingContext.findFirstTextNodeInChildElement(this._bc._contextElem, this, bl);
        this.insertChangeDeleteText(text, string);
    }

    private void insertChangeDeleteText(Text text, String string) {
        if (text != null) {
            this.changeDeleteText(text, string);
        } else if (string != null) {
            this.insertLeafElem(string);
        }
    }

    private void changeDeleteText(Text text, String string) {
        if (string != null) {
            if (!string.equals(text.getNodeValue())) {
                text.setNodeValue(string);
            }
        } else {
            Element element = (Element)text.getParentNode();
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap.getLength() > 0) {
                element.removeChild(text);
            } else {
                BindingContext.deleteElement(element);
            }
        }
    }

    private void insertLeafElem(String string) {
        Text text = this._bc._rt._document.createTextNode(string);
        Element element = this._bc.createElement(this);
        element.appendChild(text);
        this._bc.insertElem(this, element);
    }

    private void insertChangeDeleteAttr(String string) {
        Attr attr = this._bc._contextElem.getAttributeNodeNS(this._nsURI, this._localName);
        if (attr != null) {
            this.changeOrDeleteAttr(attr, string);
        } else {
            this.insertAttribute(string);
        }
    }

    private void changeOrDeleteAttr(Attr attr, String string) {
        if (string != null) {
            if (!string.equals(attr.getValue())) {
                attr.setValue(string);
            }
        } else {
            this._bc._contextElem.removeAttributeNode(attr);
        }
    }

    private void insertAttribute(String string) {
        if (string != null) {
            String string2 = this._bc.findPrefix(this._nsURI);
            if ("".equals(string2)) {
                string2 = null;
            }
            this._bc._contextElem.setAttributeNS(this._nsURI, this.getQname(string2), string);
        }
    }
}

