/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import java.lang.reflect.Method;
import oracle.javatools.xml.bind.ChoiceType;
import oracle.javatools.xml.bind.CreateImpl;
import oracle.javatools.xml.bind.ElementFilter;
import oracle.javatools.xml.bind.ElementListItemImpl;
import oracle.javatools.xml.bind.GetImpl;
import oracle.javatools.xml.bind.GetListImpl;
import oracle.javatools.xml.bind.GetMixedListImpl;
import oracle.javatools.xml.bind.GetOrCreateImpl;
import oracle.javatools.xml.bind.GetPcdataImpl;
import oracle.javatools.xml.bind.ObjectImpl;
import oracle.javatools.xml.bind.Pcdata;
import oracle.javatools.xml.bind.SetImpl;
import oracle.javatools.xml.bind.SetPcdataImpl;
import oracle.javatools.xml.bind.TypeImpl;
import oracle.javatools.xml.bind.UtilImpl;
import oracle.javatools.xml.bind.XMLBindingInfo;

public abstract class XMLBinding {
    protected abstract Class getRootInterface();

    protected Class getUtilClass() {
        return null;
    }

    protected XMLBinding getChainedBinding() {
        return null;
    }

    protected abstract XMLBindingInfo getBindingInfo(Class var1, String var2, Object[] var3);

    protected abstract int elem2intImpl(Class var1, String var2, String var3);

    protected void throwUnrecognizedElem(Class clazz, String string, String string2) {
        throw new IllegalArgumentException("Unrecognized parent-elem combination: " + clazz + " - " + string2 + " in URI '" + string + "'");
    }

    protected static XMLBindingInfo getterElem(String string) {
        return new GetImpl(0, string);
    }

    protected static XMLBindingInfo getterElemNS(String string, String string2) {
        return new GetImpl(0, string, string2);
    }

    protected static XMLBindingInfo getterAttr(String string) {
        return new GetImpl(1, string);
    }

    protected static XMLBindingInfo getterAttrNS(String string, String string2) {
        return new GetImpl(1, string, string2);
    }

    protected static XMLBindingInfo setterElem(String string) {
        return new SetImpl(0, string);
    }

    protected static XMLBindingInfo setterElemNS(String string, String string2, String string3) {
        return new SetImpl(0, string, string2, string3);
    }

    protected static XMLBindingInfo setterAttr(String string) {
        return new SetImpl(1, string);
    }

    protected static XMLBindingInfo setterAttrNS(String string, String string2, String string3) {
        return new SetImpl(1, string, string2, string3);
    }

    protected static XMLBindingInfo listElems(String string, Class clazz) {
        return new GetListImpl(null, null, string, clazz, null);
    }

    protected static XMLBindingInfo listElemsNS(String string, String string2, String string3, Class clazz) {
        return new GetListImpl(string, string2, string3, clazz, null);
    }

    protected static XMLBindingInfo listElems(String string, Class clazz, ElementFilter elementFilter) {
        return new GetListImpl(null, null, string, clazz, elementFilter);
    }

    protected static XMLBindingInfo listElemsNS(String string, String string2, String string3, Class clazz, ElementFilter elementFilter) {
        return new GetListImpl(string, string2, string3, clazz, elementFilter);
    }

    protected static XMLBindingInfo listElems(XMLBindingInfo[] xMLBindingInfoArray) {
        return new GetMixedListImpl(xMLBindingInfoArray);
    }

    protected static XMLBindingInfo listItem(String string, Class clazz, int n) {
        return new ElementListItemImpl(null, string, clazz, n);
    }

    protected static XMLBindingInfo listItemNS(String string, String string2, Class clazz, int n) {
        return new ElementListItemImpl(string, string2, clazz, n);
    }

    protected static XMLBindingInfo createElem(String string) {
        return new CreateImpl(string);
    }

    protected static XMLBindingInfo createElemNS(String string, String string2, String string3) {
        return new CreateImpl(string, string2, string3);
    }

    protected static XMLBindingInfo getOrCreateElem(String string) {
        return new GetOrCreateImpl(string);
    }

    protected static XMLBindingInfo getOrCreateElemNS(String string, String string2, String string3) {
        return new GetOrCreateImpl(string, string2, string3);
    }

    protected static XMLBindingInfo utilMethod(Class clazz) {
        return new UtilImpl(clazz);
    }

    final XMLBindingInfo getBindingInfo(Method method, Object[] objectArray) {
        Class<?> clazz = method.getDeclaringClass();
        String string = method.getName();
        XMLBinding xMLBinding = this;
        XMLBindingInfo xMLBindingInfo = null;
        while (xMLBinding != null) {
            xMLBindingInfo = xMLBinding.getBindingInfo(clazz, string, objectArray);
            if (xMLBindingInfo != null) break;
            xMLBinding = xMLBinding.getChainedBinding();
        }
        if (xMLBindingInfo != null) {
            return xMLBindingInfo.isBindingValid(method) ? xMLBindingInfo : this.tryReturnUtilMethod(xMLBinding);
        }
        if (clazz == Pcdata.class) {
            if (string == "getPcdata") {
                return new GetPcdataImpl();
            }
            if (string == "setPcdata") {
                return new SetPcdataImpl();
            }
        } else {
            if (clazz == ChoiceType.class && string == "type") {
                return new TypeImpl();
            }
            if (clazz == Object.class) {
                return new ObjectImpl();
            }
        }
        return null;
    }

    private XMLBindingInfo tryReturnUtilMethod(XMLBinding xMLBinding) {
        Class clazz;
        if (xMLBinding == null) {
            xMLBinding = this;
        }
        return (clazz = xMLBinding.getUtilClass()) != null ? XMLBinding.utilMethod(clazz) : null;
    }

    final boolean insertBetween(Class clazz, String string, String string2, String string3, String string4, String string5, String string6) {
        int n = this.elem2int(clazz, string, string2, true);
        int n2 = this.elem2int(clazz, string3, string4, false);
        int n3 = this.elem2int(clazz, string5, string6, false);
        return n3 >= n && n3 < n2;
    }

    final int elem2int(Class clazz, String string, String string2, boolean bl) {
        if (string2 == null) {
            return bl ? 0 : Integer.MAX_VALUE;
        }
        XMLBinding xMLBinding = this;
        int n = 0;
        while (xMLBinding != null) {
            n = xMLBinding.elem2intImpl(clazz, string, string2);
            if (n > 0) break;
            xMLBinding = xMLBinding.getChainedBinding();
        }
        if (n <= 0) {
            System.err.println("**** XMLBinding.elem2intImpl(..) returned non-positive index for interface '" + clazz + "' and XML element '" + string2 + "' in URI '" + string + "'.");
        }
        return n;
    }
}

