/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.bind;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLName {
    final String _nsURI;
    final String _defaultPrefix;
    final String _localName;

    public XMLName(String string, String string2, String string3) {
        this._nsURI = string;
        this._defaultPrefix = string2;
        this._localName = string3;
    }

    String getQname(String string) {
        return string != null ? this.getQnameImpl(string) : this.getQname();
    }

    private String getQname() {
        return this.getQnameImpl(this._defaultPrefix);
    }

    private String getQnameImpl(String string) {
        if (string == null || string.length() == 0) {
            return this._localName;
        }
        return string + ":" + this._localName;
    }

    static boolean isDefaultNamespace(Element element, String string) {
        String string2 = element.getPrefix();
        if (string2 == null) {
            return string.equals(element.getNamespaceURI());
        }
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (attr != null) {
            return string.equals(attr.getValue());
        }
        Element element2 = XMLName.getParentElement(element);
        if (element2 != null) {
            return XMLName.isDefaultNamespace(element2, string);
        }
        return false;
    }

    static String lookupPrefix(Element element, String string) {
        if (element == null || string == null || string.length() == 0) {
            return null;
        }
        return XMLName.lookupNamespacePrefix(element, string, element);
    }

    private static String lookupNamespacePrefix(Element element, String string, Element element2) {
        String string2;
        String string3 = element.getNamespaceURI();
        if (string3 != null && string3.equals(string) && (string2 = element.getPrefix()) != null && string.equals(XMLName.lookupNamespaceURI(element2, string2))) {
            return string2;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            if ("xmlns".equals(attr.getPrefix()) && string.equals(attr.getValue()) && string.equals(XMLName.lookupNamespaceURI(element2, attr.getLocalName()))) {
                return attr.getLocalName();
            }
            ++n2;
        }
        Element element3 = XMLName.getParentElement(element);
        if (element3 != null) {
            return XMLName.lookupNamespacePrefix(element3, string, element2);
        }
        return null;
    }

    private static String lookupNamespaceURI(Element element, String string) {
        String string2 = element.getNamespaceURI();
        if (string2 != null && string.equals(element.getPrefix())) {
            return string2;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            if ("xmlns".equals(attr.getPrefix()) && attr.getLocalName().equals(string)) {
                return XMLName.nullifyIfEmpty(attr.getValue());
            }
            if ("xmlns".equals(attr.getLocalName()) && attr.getPrefix() == null) {
                return XMLName.nullifyIfEmpty(attr.getValue());
            }
            ++n2;
        }
        Element element2 = XMLName.getParentElement(element);
        if (element2 != null) {
            return XMLName.lookupNamespaceURI(element2, string);
        }
        return null;
    }

    private static String nullifyIfEmpty(String string) {
        return string != null && string.length() > 0 ? string : null;
    }

    private static Element getParentElement(Element element) {
        Node node = element;
        do {
            if ((node = node.getParentNode()) != null) continue;
            return null;
        } while (node.getNodeType() != 1);
        return (Element)node;
    }
}

