/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.esax;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.ElementTypeResolver;
import oracle.javatools.xml.esax.HandlerException;
import oracle.javatools.xml.esax.Key;
import oracle.javatools.xml.esax.spi.Stack;

public class DynamicElementHandler
extends ElementHandler {
    public final Key sApplicationObjectKey;
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String SET_METHOD_PREFIX = "set";
    private static final String ADD_METHOD_PREFIX = "add";
    private static final Class[] sObjectParamTypes = new Class[]{Object.class};
    private static final Class[] sStringParamTypes = new Class[]{String.class};
    private final Stack _applicationObjectStack;
    private final Stack _complexTypeIndicatorStack;
    private ClassLoader _classLoader;
    private final List _resolvers;

    void $init$() {
        this.sApplicationObjectKey = new Key(DynamicElementHandler.class.getName() + ".appObjectKey");
        this._applicationObjectStack = new Stack();
        this._complexTypeIndicatorStack = new Stack();
        this._resolvers = new ArrayList(5);
    }

    public DynamicElementHandler(Object object) {
        this.$init$();
        this._applicationObjectStack.push(object);
    }

    public DynamicElementHandler(Object object, ClassLoader classLoader) {
        this(object);
        this._classLoader = classLoader;
    }

    public DynamicElementHandler(Object object, ClassLoader classLoader, ElementTypeResolver elementTypeResolver) {
        this(object, classLoader);
        this._resolvers.add(elementTypeResolver);
    }

    public void registerElementTypeResolver(ElementTypeResolver elementTypeResolver) {
        this._resolvers.add(elementTypeResolver);
    }

    public void handleStart(ElementStartContext elementStartContext) throws HandlerException {
        Class clazz = this.getRuntimeType(elementStartContext);
        this._complexTypeIndicatorStack.push(new boolean[]{clazz != null});
        if (clazz != null) {
            Object object = this.getApplicationObject(clazz, elementStartContext);
            this.invokePreInitialize(this._applicationObjectStack.peek(), object);
            this._applicationObjectStack.push(object);
            elementStartContext.putValue(this.sApplicationObjectKey, object);
            this.handleComplexElementStart(object, elementStartContext);
        } else {
            this.handleSimpleElementStart(elementStartContext);
        }
    }

    public void handleEnd(ElementEndContext elementEndContext) throws HandlerException {
        boolean bl = ((boolean[])this._complexTypeIndicatorStack.pop())[0];
        if (bl) {
            Object object = this._applicationObjectStack.pop();
            this.invokePostInitialize(object);
            this.attachObject(this._applicationObjectStack.peek(), object, elementEndContext);
            this.handleComplexElementEnd(elementEndContext);
        } else {
            this.attachData(this._applicationObjectStack.peek(), elementEndContext.getText(), elementEndContext);
            this.handleSimpleElementEnd(elementEndContext);
        }
    }

    protected void handleComplexElementStart(Object object, ElementStartContext elementStartContext) throws HandlerException {
    }

    protected void handleComplexElementEnd(ElementEndContext elementEndContext) throws HandlerException {
    }

    protected void handleSimpleElementStart(ElementStartContext elementStartContext) throws HandlerException {
    }

    protected void handleSimpleElementEnd(ElementEndContext elementEndContext) throws HandlerException {
    }

    protected Class getRuntimeType(ElementStartContext elementStartContext) throws HandlerException {
        Class clazz = null;
        String string = elementStartContext.getAttributeValue(ATTRIBUTE_CLASS);
        if (string != null) {
            try {
                clazz = Class.forName(string, true, this._classLoader != null ? this._classLoader : Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new HandlerException("Unable to load class: " + string, classNotFoundException);
            }
        } else {
            ListIterator listIterator = this._resolvers.listIterator(this._resolvers.size());
            while (listIterator.hasPrevious() && clazz == null) {
                clazz = ((ElementTypeResolver)listIterator.previous()).resolveType(elementStartContext.getNamespaceURI(), elementStartContext.getLocalName());
            }
        }
        return clazz;
    }

    protected Object getApplicationObject(Class clazz, ElementStartContext elementStartContext) throws HandlerException {
        try {
            Object t = clazz.newInstance();
            return t;
        }
        catch (Exception exception) {
            throw new HandlerException("Unable to instantiate class: " + clazz.getName(), exception);
        }
    }

    protected void attachObject(Object object, Object object2, ElementEndContext elementEndContext) throws HandlerException {
        Method method = this.findMethod(object, elementEndContext.getLocalName(), sObjectParamTypes);
        try {
            method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("Could not attach child object: ").append(object2.toString());
            stringBuffer.append(" to parent: ").append(object.toString());
            stringBuffer.append(". Root cause: ");
            stringBuffer.append(invocationTargetException.getTargetException().getClass().getName()).append(": ");
            stringBuffer.append(invocationTargetException.getTargetException().getMessage());
            throw new HandlerException(stringBuffer.toString());
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("Could not attach child object: ").append(object2.toString());
            stringBuffer.append(" to parent: ").append(object.toString());
            stringBuffer.append(". Root cause: ");
            stringBuffer.append(exception.getClass().getName()).append(": ").append(exception.getMessage());
            throw new HandlerException(stringBuffer.toString());
        }
    }

    protected void attachData(Object object, String string, ElementEndContext elementEndContext) throws HandlerException {
        Method method = this.findMethod(object, elementEndContext.getLocalName(), sStringParamTypes);
        try {
            method.invoke(object, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new HandlerException("Unable to attach data '" + string + "' for simple element " + elementEndContext.getLocalName(), invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new HandlerException("Unable to attach data '" + string + "' for simple element " + elementEndContext.getLocalName(), exception);
        }
    }

    protected void invokePreInitialize(Object object, Object object2) throws HandlerException {
    }

    protected void invokePostInitialize(Object object) throws HandlerException {
    }

    protected Method findMethod(Object object, String string, Class[] classArray) throws HandlerException {
        try {
            String string2 = this.getMethodName(SET_METHOD_PREFIX, string);
            Method method = object.getClass().getMethod(string2, classArray);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                String string3 = this.getMethodName(ADD_METHOD_PREFIX, string);
                Method method = object.getClass().getMethod(string3, classArray);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new HandlerException("Class " + object.getClass().getName() + " has no set or add method for element named " + string, noSuchMethodException2);
            }
        }
    }

    protected String getMethodName(String string, String string2) {
        char[] cArray = new char[string.length() + string2.length()];
        int n = 0;
        while (n < string.length()) {
            cArray[n] = string.charAt(n);
            ++n;
        }
        boolean bl = true;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < string2.length()) {
            if (Character.isJavaIdentifierPart(string2.charAt(n3))) {
                if (bl) {
                    cArray[n2] = Character.toUpperCase(string2.charAt(n3));
                    bl = false;
                } else {
                    cArray[n2] = string2.charAt(n3);
                }
                ++n2;
            } else {
                bl = true;
            }
            ++n3;
        }
        return new String(cArray).trim();
    }
}

