/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.esax.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementHandlerFactory;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.Key;
import oracle.javatools.xml.esax.MessageReporter;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.Stack;
import org.xml.sax.Attributes;

public class DefaultElementContext
implements ElementEndContext,
ElementStartContext,
ElementContext {
    private Attributes _attributes;
    private String _uri;
    private String _name;
    private Stack _elementPathStack;
    private Stack _contextMapStack;
    private Stack _scopeHandlers;
    private Stack _elementText;
    private Stack _childHandlers;
    private Map _ceChildHandlers;
    private XMLLocator _locator;
    private MessageReporter _messageReporter;

    void $init$() {
        this._elementPathStack = new Stack();
        this._contextMapStack = new Stack();
        this._scopeHandlers = new Stack();
        this._elementText = new Stack();
        this._childHandlers = new Stack();
        this._ceChildHandlers = null;
    }

    public DefaultElementContext() {
        this.$init$();
        this._contextMapStack.push(new HashMap());
        this._childHandlers.push(null);
    }

    void setLocator(XMLLocator xMLLocator) {
        this._locator = xMLLocator;
    }

    public String getLocalName() {
        return this._name;
    }

    public String getNamespaceURI() {
        return this._uri;
    }

    public String getPath() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/");
        Iterator iterator = this._elementPathStack.reverseIterator();
        while (iterator.hasNext()) {
            stringBuffer.append(String.valueOf(iterator.next()));
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public String getParentLocalName() {
        if (!this._elementPathStack.isEmpty()) {
            return (String)this._elementPathStack.peek();
        }
        return "";
    }

    public String getText() {
        if (this._elementText.isEmpty()) {
            throw new IllegalStateException("Cannot call getText() prior to end element");
        }
        StringBuffer stringBuffer = (StringBuffer)this._elementText.peek();
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String getAttributeValue(String string) {
        if (this._attributes == null) {
            throw new IllegalStateException("Cannot call from handleEndElement");
        }
        if (string == null) {
            throw new IllegalArgumentException("attributeName must not be null");
        }
        return this._attributes.getValue(string);
    }

    public Iterator getAttributeNames() {
        if (this._attributes == null) {
            throw new IllegalStateException();
        }
        Attributes attributes = this._attributes;
        return new 1(this, attributes);
    }

    public Object getValue(Key key) {
        for (Map map : this._contextMapStack) {
            Object v;
            if (map == null || (v = map.get(key)) == null) continue;
            return v;
        }
        return null;
    }

    public void putValue(Key key, Object object) {
        HashMap<Key, Object> hashMap = (HashMap<Key, Object>)this._contextMapStack.peek();
        if (hashMap == null) {
            hashMap = new HashMap<Key, Object>();
            this._contextMapStack.replace(hashMap);
        }
        hashMap.put(key, object);
    }

    public void removeValue(Key key) {
        Map map = (Map)this._contextMapStack.peek();
        if (map != null) {
            map.remove(key);
        }
    }

    public void registerChildHandler(String string, String string2, ElementHandler elementHandler) {
        if (this._ceChildHandlers == null) {
            this._ceChildHandlers = new HashMap();
        }
        this._ceChildHandlers.put(new QualifiedName(string, string2), elementHandler);
    }

    public void registerScopeHandler(String string, ElementHandler elementHandler) {
        this.registerScopeHandler(null, string, elementHandler);
    }

    public void registerScopeHandler(String string, String string2, ElementHandler elementHandler) {
        if (this._scopeHandlers.isEmpty()) {
            this.registerChildHandler(string, string2, elementHandler);
            return;
        }
        ScopeHandlerRegistry scopeHandlerRegistry = (ScopeHandlerRegistry)this._scopeHandlers.peek();
        if (scopeHandlerRegistry != null) {
            scopeHandlerRegistry.addStaticHandler(new QualifiedName(string, string2), elementHandler);
        }
    }

    public void registerScopeHandlerFactory(ElementHandlerFactory elementHandlerFactory) {
        if (this._scopeHandlers.isEmpty()) {
            throw new IllegalStateException("Cannot register a scope handler factory for the root");
        }
        ScopeHandlerRegistry scopeHandlerRegistry = (ScopeHandlerRegistry)this._scopeHandlers.peek();
        if (scopeHandlerRegistry != null) {
            scopeHandlerRegistry.addFactoryHandler(elementHandlerFactory);
        }
    }

    public ElementHandler getScopedHandler() {
        QualifiedName qualifiedName = new QualifiedName(this._uri, this._name);
        QualifiedName qualifiedName2 = new QualifiedName(null, this._name);
        ElementHandler elementHandler = null;
        Map map = (Map)this._childHandlers.peek();
        if (map != null) {
            elementHandler = (ElementHandler)map.get(qualifiedName);
            if (elementHandler == null) {
                elementHandler = (ElementHandler)map.get(qualifiedName2);
            }
            if (elementHandler != null) {
                return elementHandler;
            }
        }
        for (ScopeHandlerRegistry scopeHandlerRegistry : this._scopeHandlers) {
            elementHandler = scopeHandlerRegistry.getStaticHandler(qualifiedName);
            if (elementHandler != null) {
                return elementHandler;
            }
            elementHandler = scopeHandlerRegistry.getStaticHandler(qualifiedName2);
            if (elementHandler != null) {
                return elementHandler;
            }
            Iterator iterator = scopeHandlerRegistry.getFactoryHandlers();
            while (iterator.hasNext()) {
                ElementHandlerFactory elementHandlerFactory = (ElementHandlerFactory)iterator.next();
                elementHandler = elementHandlerFactory.getElementHandler(this._uri, this._name);
                if (elementHandler == null) continue;
                return elementHandler;
            }
        }
        return elementHandler;
    }

    private void setElement(String string, String string2) {
        this._uri = string;
        this._name = string2;
    }

    void beginElement(String string, String string2, Attributes attributes) {
        this.setElement(string, string2);
        this._attributes = attributes;
        this._contextMapStack.push(null);
        this._scopeHandlers.push(new ScopeHandlerRegistry(null));
        this._childHandlers.push(this._ceChildHandlers);
        this._ceChildHandlers = null;
    }

    void appendCharacters(char[] cArray, int n, int n2) {
        if (this._elementText.isEmpty()) {
            throw new IllegalStateException();
        }
        StringBuffer stringBuffer = (StringBuffer)this._elementText.peek();
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            this._elementText.replace(stringBuffer);
        }
        stringBuffer.append(cArray, n, n2);
    }

    void postEndElement() {
        this._scopeHandlers.pop();
        this._contextMapStack.pop();
        this._elementText.pop();
        this._ceChildHandlers = (Map)this._childHandlers.peek();
        this._childHandlers.pop();
        this._name = null;
        this._attributes = null;
        this._uri = null;
    }

    void endElement(String string, String string2) {
        this.setElement(string, string2);
        this._attributes = null;
        this._elementPathStack.pop();
    }

    void postBeginElement() {
        this._elementPathStack.push(this._name);
        this._elementText.push(null);
    }

    public XMLLocator getLocator() {
        return this._locator;
    }

    public MessageReporter getMessageReporter() {
        if (this._messageReporter == null) {
            this._messageReporter = new NullReporter(null);
        }
        return this._messageReporter;
    }

    public void setMessageReporter(MessageReporter messageReporter) {
        this._messageReporter = messageReporter;
    }

    public final class 1
    implements Iterator {
        private int _currentIndex;
        private final /* synthetic */ Attributes v$attributes;
        final /* synthetic */ DefaultElementContext this$0;

        void $init$() {
            this._currentIndex = 0;
        }

        public boolean hasNext() {
            return this._currentIndex < this.v$attributes.getLength();
        }

        public Object next() {
            if (this._currentIndex >= this.v$attributes.getLength()) {
                throw new ArrayIndexOutOfBoundsException(String.valueOf(this._currentIndex) + " >= " + this.v$attributes.getLength());
            }
            return this.v$attributes.getLocalName(this._currentIndex++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public 1(DefaultElementContext defaultElementContext, Attributes attributes) {
            this.v$attributes = attributes;
            this.this$0 = defaultElementContext;
            this.$init$();
        }
    }

    private class NullReporter
    implements MessageReporter {
        public void severe(XMLLocator xMLLocator, String string, Throwable throwable) {
        }

        public void error(XMLLocator xMLLocator, String string, Throwable throwable) {
        }

        public void warning(XMLLocator xMLLocator, String string) {
        }

        public void information(XMLLocator xMLLocator, String string) {
        }

        private NullReporter() {
        }

        NullReporter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ScopeHandlerRegistry {
        private List _factoryHandlers;
        private Map _staticHandlers;

        public Iterator getFactoryHandlers() {
            if (this._factoryHandlers == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return this._factoryHandlers.iterator();
        }

        public ElementHandler getStaticHandler(QualifiedName qualifiedName) {
            if (this._staticHandlers == null) {
                return null;
            }
            return (ElementHandler)this._staticHandlers.get(qualifiedName);
        }

        public void addFactoryHandler(ElementHandlerFactory elementHandlerFactory) {
            if (this._factoryHandlers == null) {
                this._factoryHandlers = new ArrayList();
            }
            this._factoryHandlers.add(elementHandlerFactory);
        }

        public void addStaticHandler(QualifiedName qualifiedName, ElementHandler elementHandler) {
            if (this._staticHandlers == null) {
                this._staticHandlers = new HashMap();
            }
            this._staticHandlers.put(qualifiedName, elementHandler);
        }

        private ScopeHandlerRegistry() {
        }

        ScopeHandlerRegistry(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class QualifiedName {
        private final String _namespaceURI;
        private final String _localName;

        public QualifiedName(String string, String string2) {
            this._namespaceURI = string;
            this._localName = string2;
        }

        public String getNamespaceURI() {
            return this._namespaceURI;
        }

        public String getLocalName() {
            return this._localName;
        }

        public String toString() {
            return "Namespace: " + String.valueOf(this._namespaceURI) + ", Local Name: " + String.valueOf(this._localName);
        }

        public int hashCode() {
            int n = 213465;
            if (this._namespaceURI != null) {
                n += this._namespaceURI.hashCode();
            }
            if (this._localName != null) {
                n += this._localName.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof QualifiedName) {
                return String.valueOf(this._namespaceURI).equals(String.valueOf(((QualifiedName)object)._namespaceURI)) && String.valueOf(this._localName).equals(String.valueOf(((QualifiedName)object)._localName));
            }
            return false;
        }
    }
}

