/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.esax.spi;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Stack
extends AbstractCollection {
    private ArrayList _list;

    public Stack() {
    }

    public Stack(Collection collection) {
        this.addAll(collection);
    }

    private List getList() {
        if (this._list == null) {
            this._list = new ArrayList();
        }
        return this._list;
    }

    public boolean isEmpty() {
        return this._list == null || this._list.isEmpty();
    }

    public boolean push(Object object) {
        return this.getList().add(object);
    }

    public Object peek() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Illegal peek()");
        }
        List list = this.getList();
        return list.get(list.size() - 1);
    }

    public void replace(Object object) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Illegal replace()");
        }
        List list = this.getList();
        list.set(list.size() - 1, object);
    }

    public Object pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Illegal pop()");
        }
        List list = this.getList();
        int n = list.size() - 1;
        Object e = list.get(n);
        list.remove(n);
        if (list.isEmpty()) {
            this._list = null;
        }
        return e;
    }

    public Iterator reverseIterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this._list.iterator();
    }

    public boolean add(Object object) {
        return this.push(object);
    }

    public void clear() {
        this.getList().clear();
    }

    public Iterator iterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new ReverseListIterator(this._list);
    }

    public int size() {
        return this.getList().size();
    }

    private static final class ReverseListIterator
    implements Iterator {
        private final ListIterator _listIterator;

        public ReverseListIterator(List list) {
            this._listIterator = list.listIterator(list.size());
        }

        public boolean hasNext() {
            return this._listIterator.hasPrevious();
        }

        public Object next() {
            return this._listIterator.previous();
        }

        public void remove() {
            this._listIterator.remove();
        }
    }
}

