<?xml version = '1.0' encoding = 'windows-1252'?>

<!-- 
 * @(#)tools-904-to-905.xsl
 *
 * Copyright 2002 by Oracle Corporation,
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Oracle Corporation.
-->

<!-- Test -->
<!--
* This stylesheet transforms a 9.0.2, 9.0.3 or 9.0.4 tool definition file
* to the new format for 9.0.5.
*
* Author: Brian.Duff@oracle.com
-->

<!-- prior to 9.0.5, there was no namespace on the document: in 9.0.5, we use
     a namespace to uniquely distinguish this version of the file format. -->
<!DOCTYPE xsl:stylesheet [

<!ENTITY newns 'http://xmlns.oracle.com/jdeveloper/905/externaltools'>
<!ENTITY oldargpkg 'oracle.jdevimpl.toolmanager.argument'>
<!ENTITY newtoolclass 'oracle.jdevimpl.externaltools.program.ExternalProgramTool'>
<!ENTITY programtype 'oracle.jdevimpl.externaltools.program.ExternalProgramType'>
<!ENTITY oldDefaultIcon 'oracle/jdevimpl/toolmanager/tool.gif'>
<!ENTITY newDefaultIcon 'oracle/jdevimpl/externaltools/program/programtool.gif'>
]>

<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns="&newns;"
    xmlns:macromap="urn:macromap">


  <!-- Mapping from old (9.0.2/3/4) macro names and argument classes
       to new (9.0.5) macros-->
  <macromap:map>
    <macromap:entry>
      <macromap:old>{parentDir}</macromap:old>
      <macromap:oldclass>&oldargpkg;.FileParentDir</macromap:oldclass>
      <macromap:new>${file.dir}</macromap:new>
    </macromap:entry>
    <macromap:entry>
      <macromap:old>{fileName}</macromap:old>
      <macromap:oldclass>&oldargpkg;.FileName</macromap:oldclass>      
      <macromap:new>${file.name}</macromap:new>
    </macromap:entry>
    <macromap:entry>
      <macromap:old>{fileNameNoExtension}</macromap:old>
      <macromap:oldclass>&oldargpkg;.FileNameNoExtension</macromap:oldclass>      
      <macromap:new>${file.name.no.ext}</macromap:new>
    </macromap:entry>
    <macromap:entry>
      <macromap:old>{path}</macromap:old>
      <macromap:oldclass>&oldargpkg;.Path</macromap:oldclass>      
      <macromap:new>${file.path}</macromap:new>
    </macromap:entry>
    <macromap:entry>
      <macromap:old>{url}</macromap:old>
      <macromap:oldclass>&oldargpkg;.FullURL</macromap:oldclass>      
      <macromap:new>${file.url}</macromap:new>
    </macromap:entry>    
    <macromap:entry>
      <macromap:old>{ideInstallDir}</macromap:old>
      <macromap:oldclass>&oldargpkg;.IDEInstallDir</macromap:oldclass>      
      <macromap:new>${ide.dir}</macromap:new>
    </macromap:entry>  
    <macromap:entry>
      <macromap:old>{classpath}</macromap:old>
      <macromap:oldclass>&oldargpkg;.ProjectClasspath</macromap:oldclass>      
      <macromap:new>${project.classpath}</macromap:new>
    </macromap:entry>  
    <macromap:entry>
      <macromap:old>{htmlRoot}</macromap:old>
      <macromap:oldclass>&oldargpkg;.ProjectHTMLRoot</macromap:oldclass>      
      <macromap:new>${project.html.root}</macromap:new>
    </macromap:entry>  
    <macromap:entry>
      <macromap:old>{defaultSourcePath}</macromap:old>
      <macromap:oldclass>&oldargpkg;.DefaultSourcepath</macromap:oldclass>      
      <macromap:new>${project.first.sourcepath}</macromap:new>
    </macromap:entry>    
    <macromap:entry>
      <macromap:old>{outputDirectory}</macromap:old>
      <macromap:oldclass>&oldargpkg;.OutputDirectory</macromap:oldclass>      
      <macromap:new>${project.output.dir}</macromap:new>
    </macromap:entry>     
    <macromap:entry>
      <macromap:old>{sourcePath}</macromap:old>
      <macromap:oldclass>&oldargpkg;.ProjectSourcepath</macromap:oldclass>      
      <macromap:new>${project.sourcepath}</macromap:new>
    </macromap:entry>  
    <macromap:entry>
      <macromap:old>{prompt}</macromap:old>
      <macromap:oldclass>&oldargpkg;.Prompt</macromap:oldclass>      
      <macromap:new>${prompt}</macromap:new>
    </macromap:entry>  
    <macromap:entry>
      <macromap:old>{fullClassName}</macromap:old>
      <macromap:oldclass>&oldargpkg;.FullClassName</macromap:oldclass>      
      <macromap:new>${target.class}</macromap:new>
    </macromap:entry>  
    <macromap:entry>
      <macromap:old>{packageName}</macromap:old>
      <macromap:oldclass>&oldargpkg;.PackageName</macromap:oldclass>      
      <macromap:new>${target.package}</macromap:new>
    </macromap:entry>      
  </macromap:map>

  <xsl:output indent="yes"/>
  
  <!-- root template -->
  <xsl:template match="tools">
    <tools class="java.util.ArrayList">
      <xsl:apply-templates select="Item" />
    </tools>
  </xsl:template>
  
  <!--
  *  Individual external tool definitions. All old tools map to external
  *  program type tools.
  -->
  <xsl:template match="/tools/Item">
    <Item class="&newtoolclass;">
      <xsl:apply-templates select="arguments" />
    
      <executable><xsl:value-of select="command" /></executable>
      <availabilityExpression class="java.lang.String"><xsl:value-of select="enableRegularExpression" /></availabilityExpression>
      <caption><xsl:value-of select="title" /></caption>
      <iconURL> 
        <!--
        
        Don't migrate icon, because of absolute path issues...
        
        <xsl:choose>
          <xsl:when test="boolean(iconURL/@jar-entry='&oldDefaultIcon;')">
            <xsl:copy-of select="iconURL/@path" />
            <xsl:attribute name="jar-entry">&newDefaultIcon;</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:copy-of select="iconURL/@path | iconURL/@host | iconURL/@jar-entry" />
          </xsl:otherwise>
        </xsl:choose>
        -->
      </iconURL>
      <toolTipText><xsl:value-of select="toolTip" /></toolTipText>
      <runDirectory>
        <xsl:for-each select="workingDirectory">
          <xsl:call-template name="renameOldMacros" />
        </xsl:for-each>
      </runDirectory>
          
      
      <availability><xsl:value-of select="enableType" /></availability>
      
      <xsl:variable name="toolsMenu">
        <xsl:choose>
          <xsl:when test="toolsMenuItem='true'">1</xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name="codeEditorContextMenu">
        <xsl:choose>        
          <xsl:when test="codeEditorContextMenuItem='true'">2</xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>            
      </xsl:variable>

      <xsl:variable name="navigatorContextMenu">
        <xsl:choose>        
          <xsl:when test="contextMenuItem='true'">4</xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>            
      </xsl:variable>

      <xsl:variable name="toolbarButton">
        <xsl:choose>        
          <xsl:when test="toolbarButton='true'">8</xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>            
      </xsl:variable>
      
      <!-- now write out the sum of these values as the integrationMask -->
      <integrationMask><xsl:value-of select="$toolsMenu + $codeEditorContextMenu + $navigatorContextMenu + $toolbarButton" /></integrationMask>
    </Item>
  </xsl:template>
  
  <xsl:template match="/tools/Item/arguments">
    <arguments>
      <xsl:apply-templates select="Item" />
    </arguments>
  </xsl:template>
  
  <!--
   * Transform an argument
  -->
  <xsl:template match="tools/Item/arguments/Item">
    
    <xsl:variable name="classname" select="@class" />
    
    <!-- Transform argument classes into macros -->
    <xsl:for-each select="document('')/*/macromap:map/macromap:entry[macromap:oldclass=$classname]">
      <xsl:text>"</xsl:text>
      <xsl:value-of select="document('')/*/macromap:map/macromap:entry[macromap:oldclass=$classname]/macromap:new" />
      <xsl:text>" </xsl:text>
    </xsl:for-each>
    
    <!-- Deal with special cases (text argument and IDREFs -->
    <xsl:choose>
    
      <xsl:when test="@class='&oldargpkg;.TextArgument'">
        <xsl:text>"</xsl:text><xsl:for-each select="text"><xsl:call-template name="renameOldMacros"/></xsl:for-each><xsl:text>" </xsl:text>
      </xsl:when>      
      
      <!-- Tricky Object2DOM IDREF stuff -->
      <xsl:when test="boolean(@idref)">
        <xsl:variable name="theid"><xsl:value-of select="@idref" /></xsl:variable>
        <xsl:apply-templates select="//Item[@id=$theid]" />
      </xsl:when>
    
    </xsl:choose>  
  </xsl:template>
  
  <!-- 
     Rename old macros to their new names
    -->
  <xsl:template name="renameOldMacros">
 
    <xsl:call-template name="replace-macros">
      <xsl:with-param name="input-text" select="." />
    </xsl:call-template>
    
  </xsl:template>


  <xsl:template name="replace-macros">
    <xsl:param name="input-text" />
    <xsl:param name="search"
      select="document('')/*/macromap:map/macromap:entry" />
      
  
    <xsl:variable name="replacedText">
      <xsl:call-template name="replace">
        <xsl:with-param name="text" select="$input-text" />
        <xsl:with-param name="replace" select="$search[1]/macromap:old" />
        <xsl:with-param name="with" select="$search[1]/macromap:new" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$search[2]">
        <xsl:call-template name="replace-macros">
          <xsl:with-param name="input-text" select="$replacedText" />
          <xsl:with-param name="search" select="$search[position() + 1]" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$replacedText" />
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>


  <!-- General string search / replace -->
  <xsl:template name="replace">
    <xsl:param name="text" />
    <xsl:param name="replace" />
    <xsl:param name="with" />
    
    
    <xsl:choose>
      <xsl:when test="string-length($replace) = 0">
        <xsl:value-of select="$text" />
      </xsl:when>
      <xsl:when test="contains($text, $replace)">
        <xsl:variable name="before" select="substring-before($text, $replace)" />
        <xsl:variable name="after" select="substring-after($text, $replace)" />
        
        <xsl:value-of select="$before" />
        <xsl:value-of select="$with" />
        <xsl:call-template name="replace">
          <xsl:with-param name="text" select="$after" />
          <xsl:with-param name="replace" select="$replace" />
          <xsl:with-param name="with" select="$with" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
